/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.httpclient;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentProcessor;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.attachment.http.HttpResponseAttachment;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class AllureHttpClientResponse
implements HttpResponseInterceptor {
    private final AttachmentRenderer<AttachmentData> renderer;
    private final AttachmentProcessor<AttachmentData> processor;

    public AllureHttpClientResponse() {
        this((AttachmentRenderer<AttachmentData>)new FreemarkerAttachmentRenderer("http-response.ftl"), (AttachmentProcessor<AttachmentData>)new DefaultAttachmentProcessor());
    }

    public AllureHttpClientResponse(AttachmentRenderer<AttachmentData> renderer, AttachmentProcessor<AttachmentData> processor) {
        this.renderer = renderer;
        this.processor = processor;
    }

    public void process(HttpResponse response, HttpContext context) throws IOException {
        HttpResponseAttachment.Builder builder = HttpResponseAttachment.Builder.create((String)"Response").setResponseCode(response.getStatusLine().getStatusCode());
        Stream.of(response.getAllHeaders()).forEach(header -> builder.setHeader(header.getName(), header.getValue()));
        if (response.getEntity() != null) {
            if (!response.getEntity().isRepeatable()) {
                BufferedHttpEntity bufferedEntity = new BufferedHttpEntity(response.getEntity());
                response.setEntity((HttpEntity)bufferedEntity);
            }
            builder.setBody(EntityUtils.toString((HttpEntity)response.getEntity()));
        } else {
            builder.setBody("No body present");
        }
        HttpResponseAttachment responseAttachment = builder.build();
        this.processor.addAttachment((AttachmentData)responseAttachment, this.renderer);
    }
}

