/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.AllureResultsWriteException;
import io.qameta.allure.AllureResultsWriter;
import io.qameta.allure.model.Allure2ModelJackson;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.UUID;

public class FileSystemResultsWriter
implements AllureResultsWriter {
    private final Path outputDirectory;
    private final ObjectMapper mapper;

    public FileSystemResultsWriter(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.mapper = Allure2ModelJackson.createMapper();
    }

    @Override
    public void write(TestResult testResult) {
        String testResultName = Objects.isNull(testResult.getUuid()) ? FileSystemResultsWriter.generateTestResultName() : FileSystemResultsWriter.generateTestResultName(testResult.getUuid());
        this.createDirectories(this.outputDirectory);
        Path file = this.outputDirectory.resolve(testResultName);
        try {
            this.mapper.writeValue(file.toFile(), (Object)testResult);
        }
        catch (IOException e) {
            throw new AllureResultsWriteException("Could not write Allure test result", e);
        }
    }

    @Override
    public void write(TestResultContainer testResultContainer) {
        String testResultContainerName = Objects.isNull(testResultContainer.getUuid()) ? FileSystemResultsWriter.generateTestResultContainerName() : FileSystemResultsWriter.generateTestResultContainerName(testResultContainer.getUuid());
        this.createDirectories(this.outputDirectory);
        Path file = this.outputDirectory.resolve(testResultContainerName);
        try {
            this.mapper.writeValue(file.toFile(), (Object)testResultContainer);
        }
        catch (IOException e) {
            throw new AllureResultsWriteException("Could not write Allure test result container", e);
        }
    }

    @Override
    public void write(String source, InputStream attachment) {
        this.createDirectories(this.outputDirectory);
        Path file = this.outputDirectory.resolve(source);
        try (InputStream is = attachment;){
            Files.copy(is, file, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new AllureResultsWriteException("Could not write Allure attachment", e);
        }
    }

    private void createDirectories(Path directory) {
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AllureResultsWriteException("Could not create Allure results directory", e);
        }
    }

    protected static String generateTestResultName() {
        return FileSystemResultsWriter.generateTestResultName(UUID.randomUUID().toString());
    }

    protected static String generateTestResultName(String uuid) {
        return uuid + "-result.json";
    }

    protected static String generateTestResultContainerName() {
        return FileSystemResultsWriter.generateTestResultContainerName(UUID.randomUUID().toString());
    }

    protected static String generateTestResultContainerName(String uuid) {
        return uuid + "-container.json";
    }
}

