/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.internal;

import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.model.WithSteps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class AllureStorage {
    private final Map<String, Object> storage = new ConcurrentHashMap<String, Object>();
    private final ThreadLocal<LinkedList<String>> currentStepContext = new InheritableThreadLocal<LinkedList<String>>(){

        @Override
        public LinkedList<String> initialValue() {
            return new LinkedList<String>();
        }
    };

    public Optional<String> getCurrentStep() {
        LinkedList<String> uids = this.currentStepContext.get();
        return uids.isEmpty() ? Optional.empty() : Optional.of(uids.getFirst());
    }

    public String getRootStep() {
        LinkedList<String> uids = this.currentStepContext.get();
        return uids.isEmpty() ? null : uids.getLast();
    }

    public void startStep(String uuid) {
        this.currentStepContext.get().push(uuid);
    }

    public void stopStep() {
        this.currentStepContext.get().pop();
    }

    public void clearStepContext() {
        this.currentStepContext.remove();
    }

    public Optional<TestResultContainer> getContainer(String uuid) {
        return this.get(uuid, TestResultContainer.class);
    }

    public void addContainer(TestResultContainer container) {
        this.put(container.getUuid(), container);
    }

    public Optional<TestResultContainer> removeContainer(String uuid) {
        return this.remove(uuid, TestResultContainer.class);
    }

    public void addTestResult(TestResult testResult) {
        this.put(testResult.getUuid(), testResult);
    }

    public Optional<TestResult> getTestResult(String uuid) {
        return this.get(uuid, TestResult.class);
    }

    public Optional<TestResult> removeTestResult(String uuid) {
        return this.remove(uuid, TestResult.class);
    }

    public Optional<FixtureResult> getFixture(String uuid) {
        return this.get(uuid, FixtureResult.class);
    }

    public void addFixture(String uuid, FixtureResult fixtureResult) {
        this.put(uuid, fixtureResult);
    }

    public Optional<FixtureResult> removeFixture(String uuid) {
        return this.remove(uuid, FixtureResult.class);
    }

    public Optional<StepResult> getStep(String uuid) {
        return this.get(uuid, StepResult.class);
    }

    public void addStep(String parentUuid, String uuid, StepResult step) {
        this.put(uuid, step);
        this.get(parentUuid, WithSteps.class).ifPresent(parentStep -> parentStep.getSteps().add(step));
    }

    public Optional<StepResult> removeStep(String uuid) {
        return this.remove(uuid, StepResult.class);
    }

    public <T> T put(String uuid, T item) {
        Objects.requireNonNull(uuid, "Can't put item to storage: uuid can't be null");
        this.storage.put(uuid, item);
        return item;
    }

    public <T> Optional<T> get(String uuid, Class<T> clazz) {
        Objects.requireNonNull(uuid, "Can't get item from storage: uuid can't be null");
        return Optional.ofNullable(this.storage.get(uuid)).map(item -> this.cast(item, clazz));
    }

    public <T> Optional<T> remove(String uuid, Class<T> clazz) {
        Objects.requireNonNull(uuid, "Can't remove item from storage: uuid can't be null");
        return Optional.ofNullable(this.storage.remove(uuid)).map(item -> this.cast(item, clazz));
    }

    public <T> T cast(Object obj, Class<T> clazz) {
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        throw new IllegalStateException("Can not cast " + obj + " to " + clazz);
    }
}

