/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public final class Allure {
    private static final String TXT_EXTENSION = ".txt";
    private static final String TEXT_PLAIN = "text/plain";
    private static AllureLifecycle lifecycle;

    private Allure() {
        throw new IllegalStateException("Do not instance");
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = new AllureLifecycle();
        }
        return lifecycle;
    }

    public static void addLabels(Label ... labels) {
        Allure.getLifecycle().updateTestCase(testResult -> testResult.setLabels(labels));
    }

    public static void addLinks(Link ... links) {
        Allure.getLifecycle().updateTestCase(testResult -> testResult.setLinks(links));
    }

    public static void addDescription(String description) {
        Allure.getLifecycle().updateTestCase(executable -> executable.setDescription(description));
    }

    public static void addDescriptionHtml(String descriptionHtml) {
        Allure.getLifecycle().updateTestCase(executable -> executable.setDescriptionHtml(descriptionHtml));
    }

    public static void addAttachment(String name, String content) {
        Allure.getLifecycle().addAttachment(name, TEXT_PLAIN, TXT_EXTENSION, content.getBytes(StandardCharsets.UTF_8));
    }

    public static void addAttachment(String name, String type, String content) {
        Allure.getLifecycle().addAttachment(name, type, TXT_EXTENSION, content.getBytes(StandardCharsets.UTF_8));
    }

    public static void addAttachment(String name, String type, String content, String fileExtension) {
        Allure.getLifecycle().addAttachment(name, type, fileExtension, content.getBytes(StandardCharsets.UTF_8));
    }

    public static void addAttachment(String name, InputStream content) {
        Allure.getLifecycle().addAttachment(name, null, null, content);
    }

    public static void addAttachment(String name, String type, InputStream content, String fileExtension) {
        Allure.getLifecycle().addAttachment(name, type, fileExtension, content);
    }

    public static CompletableFuture<byte[]> addByteAttachmentAsync(String name, String type, Supplier<byte[]> body) {
        return Allure.addByteAttachmentAsync(name, type, "", body);
    }

    public static CompletableFuture<byte[]> addByteAttachmentAsync(String name, String type, String fileExtension, Supplier<byte[]> body) {
        String source = Allure.getLifecycle().prepareAttachment(name, type, fileExtension);
        return CompletableFuture.supplyAsync(body).whenComplete((result, ex) -> Allure.getLifecycle().writeAttachment(source, new ByteArrayInputStream((byte[])result)));
    }

    public static CompletableFuture<InputStream> addStreamAttachmentAsync(String name, String type, Supplier<InputStream> body) {
        return Allure.addStreamAttachmentAsync(name, type, "", body);
    }

    public static CompletableFuture<InputStream> addStreamAttachmentAsync(String name, String type, String fileExtension, Supplier<InputStream> body) {
        String source = lifecycle.prepareAttachment(name, type, fileExtension);
        return CompletableFuture.supplyAsync(body).whenComplete((result, ex) -> lifecycle.writeAttachment(source, (InputStream)result));
    }

    public static void setLifecycle(AllureLifecycle lifecycle) {
        Allure.lifecycle = lifecycle;
    }
}

