/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.aspects.Allure1Utils;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.aspectj.lang.reflect.MethodSignature;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Severity;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.allure.model.DescriptionType;

final class Allure1Annotations {
    private static final String SUITE_LABEL = "suite";
    private final MethodSignature signature;
    private final Object[] args;

    Allure1Annotations(MethodSignature signature, Object ... args) {
        this.args = Arrays.copyOf(args, args.length);
        this.signature = signature;
    }

    public void updateTitle(TestResult result) {
        Class<?> type;
        Method method = this.getMethod();
        if (method.isAnnotationPresent(Title.class)) {
            Title title = method.getAnnotation(Title.class);
            result.setName(title.value());
        }
        if ((type = this.getType()).isAnnotationPresent(Title.class)) {
            Title title = type.getAnnotation(Title.class);
            List labels = result.getLabels().stream().filter(label -> !SUITE_LABEL.equals(label.getName())).collect(Collectors.toList());
            labels.add(new Label().setName(SUITE_LABEL).setValue(title.value()));
            result.setLabels(labels);
        }
    }

    public void updateDescription(TestResult result) {
        Method method = this.getMethod();
        if (method.isAnnotationPresent(Description.class)) {
            Description description = method.getAnnotation(Description.class);
            if (description.type().equals((Object)DescriptionType.HTML)) {
                result.setDescriptionHtml(description.value());
            } else {
                result.setDescription(description.value());
            }
        }
    }

    public void updateLabels(TestResult result) {
        result.getLabels().addAll(this.getLabels());
    }

    public void updateLinks(TestResult result) {
        result.getLinks().addAll(this.getLinks());
    }

    public void updateParameters(TestResult result) {
        result.getParameters().addAll(this.getMethodParameters());
    }

    private List<Parameter> getMethodParameters() {
        String[] parameterNames = this.signature.getParameterNames();
        return IntStream.range(0, parameterNames.length).mapToObj(index -> ResultsUtils.createParameter((String)parameterNames[index], (Object)this.args[index])).collect(Collectors.toList());
    }

    private Class<?> getType() {
        return this.signature.getMethod().getDeclaringClass();
    }

    private Method getMethod() {
        return this.signature.getMethod();
    }

    private List<Label> getLabels() {
        Method method = this.getMethod();
        ArrayList<Label> labels = new ArrayList<Label>();
        labels.addAll(Allure1Utils.getLabels(method, Severity.class, Allure1Utils::createLabels));
        labels.addAll(Allure1Utils.getLabels(method, Stories.class, Allure1Utils::createLabels));
        labels.addAll(Allure1Utils.getLabels(method, Features.class, Allure1Utils::createLabels));
        return labels;
    }

    public List<Link> getLinks() {
        Method method = this.getMethod();
        ArrayList<Link> links = new ArrayList<Link>();
        links.addAll(Allure1Utils.getLinks(method, TestCaseId.class, Allure1Utils::createLinks));
        links.addAll(Allure1Utils.getLinks(method, Issue.class, Allure1Utils::createLinks));
        links.addAll(Allure1Utils.getLinks(method, Issues.class, Allure1Utils::createLinks));
        return links;
    }
}

