/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.aspects.Allure1Utils;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import ru.yandex.qatools.allure.annotations.Attachment;

@Aspect
public class Allure1AttachAspects {
    private static AllureLifecycle lifecycle;

    @Pointcut(value="@annotation(ru.yandex.qatools.allure.annotations.Attachment)")
    public void withAttachmentAnnotation() {
    }

    @Pointcut(value="execution(* *(..))")
    public void anyMethod() {
    }

    @AfterReturning(pointcut="anyMethod() && withAttachmentAnnotation()", returning="result")
    public void attachment(JoinPoint joinPoint, Object result) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Attachment attachment = methodSignature.getMethod().getAnnotation(Attachment.class);
        String title = Allure1Utils.getTitle(attachment.value(), methodSignature.getName(), joinPoint.getThis(), joinPoint.getArgs());
        byte[] bytes = result instanceof byte[] ? (byte[])result : Objects.toString(result).getBytes(StandardCharsets.UTF_8);
        Allure1AttachAspects.getLifecycle().addAttachment(title, attachment.type(), "", bytes);
    }

    public static void setLifecycle(AllureLifecycle lifecycle) {
        Allure1AttachAspects.lifecycle = lifecycle;
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }
}

