/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.util.ResultsUtils;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.FieldSignature;
import ru.yandex.qatools.allure.annotations.Parameter;

@Aspect
public class Allure1ParametersAspects {
    private static AllureLifecycle lifecycle;

    @Pointcut(value="@annotation(ru.yandex.qatools.allure.annotations.Parameter)")
    public void withParameterAnnotation() {
    }

    @Pointcut(value="set(* *)")
    public void setValueToAnyField() {
    }

    @After(value="setValueToAnyField() && withParameterAnnotation()")
    public void parameterValueChanged(JoinPoint joinPoint) {
        try {
            FieldSignature fieldSignature = (FieldSignature)joinPoint.getSignature();
            Parameter parameter = fieldSignature.getField().getAnnotation(Parameter.class);
            String name = parameter.value().isEmpty() ? fieldSignature.getName() : parameter.value();
            String value = Objects.toString(joinPoint.getArgs()[0]);
            Allure1ParametersAspects.getLifecycle().updateTestCase(testResult -> testResult.getParameters().add(ResultsUtils.createParameter((String)name, (Object)value)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle = allure;
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }
}

