/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.aspects.Allure1Utils;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ResultsUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import ru.yandex.qatools.allure.annotations.Step;

@Aspect
public class Allure1StepsAspects {
    private static AllureLifecycle lifecycle;

    @Pointcut(value="@annotation(ru.yandex.qatools.allure.annotations.Step)")
    public void withStepAnnotation() {
    }

    @Pointcut(value="execution(* *(..))")
    public void anyMethod() {
    }

    @Before(value="anyMethod() && withStepAnnotation()")
    public void stepStart(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String uuid = UUID.randomUUID().toString();
        StepResult result = new StepResult().setName(this.createTitle(joinPoint)).setParameters(Allure1StepsAspects.getParameters(methodSignature, joinPoint.getArgs()));
        Allure1StepsAspects.getLifecycle().startStep(uuid, result);
    }

    @AfterThrowing(pointcut="anyMethod() && withStepAnnotation()", throwing="e")
    public void stepFailed(JoinPoint joinPoint, Throwable e) {
        Allure1StepsAspects.getLifecycle().updateStep(result -> result.setStatus(ResultsUtils.getStatus((Throwable)e).orElse(Status.BROKEN)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)e).orElse(null)));
        Allure1StepsAspects.getLifecycle().stopStep();
    }

    @AfterReturning(pointcut="anyMethod() && withStepAnnotation()", returning="result")
    public void stepStop(JoinPoint joinPoint, Object result) {
        Allure1StepsAspects.getLifecycle().updateStep(step -> step.setStatus(Status.PASSED));
        Allure1StepsAspects.getLifecycle().stopStep();
    }

    public String createTitle(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Step step = methodSignature.getMethod().getAnnotation(Step.class);
        return step.value().isEmpty() ? Allure1Utils.getName(methodSignature.getName(), joinPoint.getArgs()) : Allure1Utils.getTitle(step.value(), methodSignature.getName(), joinPoint.getThis(), joinPoint.getArgs());
    }

    private static List<Parameter> getParameters(MethodSignature signature, Object ... args) {
        return IntStream.range(0, args.length).mapToObj(index -> ResultsUtils.createParameter((String)signature.getParameterNames()[index], (Object)args[index])).collect(Collectors.toList());
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle = allure;
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }
}

