/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.aspects.Allure1Annotations;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class Allure1TestCaseAspects {
    private static AllureLifecycle lifecycle;

    @Before(value="execution(@org.junit.Test * *.*(..))")
    public void junitTestStart(JoinPoint joinPoint) {
        this.updateTestCase(joinPoint);
    }

    @Before(value="execution(@org.testng.annotations.Test * *.*(..))")
    public void testNgTestStart(JoinPoint joinPoint) {
        this.updateTestCase(joinPoint);
    }

    private void updateTestCase(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Object[] args = joinPoint.getArgs();
        Allure1Annotations annotations = new Allure1Annotations(signature, args);
        Allure1TestCaseAspects.getLifecycle().getCurrentTestCase().ifPresent(uuid -> {
            Allure1TestCaseAspects.getLifecycle().updateTestCase(uuid, annotations::updateTitle);
            Allure1TestCaseAspects.getLifecycle().updateTestCase(uuid, annotations::updateDescription);
            Allure1TestCaseAspects.getLifecycle().updateTestCase(uuid, annotations::updateParameters);
            Allure1TestCaseAspects.getLifecycle().updateTestCase(uuid, annotations::updateLabels);
            Allure1TestCaseAspects.getLifecycle().updateTestCase(uuid, annotations::updateLinks);
        });
    }

    public static void setLifecycle(AllureLifecycle lifecycle) {
        Allure1TestCaseAspects.lifecycle = lifecycle;
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }
}

