/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.util.ResultsUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Severity;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.TestCaseId;

final class Allure1Utils {
    private static final String SEVERITY_LABEL = "severity";
    private static final String FEATURE_LABEL = "feature";
    private static final String STORY_LABEL = "story";

    private Allure1Utils() {
    }

    public static String getName(String methodName, Object ... parameters) {
        return methodName + Allure1Utils.getParametersAsString(parameters);
    }

    public static String getParametersAsString(Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = 0; i < parameters.length; ++i) {
            builder.append(Allure1Utils.arrayToString(parameters[i]));
            if (i >= parameters.length - 1) continue;
            builder.append(", ");
        }
        return builder.append(']').toString();
    }

    public static String getTitle(String namePattern, String methodName, Object instance, Object ... parameters) {
        String finalPattern = namePattern.replaceAll("\\{method}", methodName).replaceAll("\\{this}", String.valueOf(instance));
        int paramsCount = parameters == null ? 0 : parameters.length;
        Object[] results = new Object[paramsCount];
        for (int i = 0; i < paramsCount; ++i) {
            results[i] = Allure1Utils.arrayToString(parameters[i]);
        }
        return MessageFormat.format(finalPattern, results);
    }

    public static Object arrayToString(Object obj) {
        if (obj != null && obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            Object[] strings = new String[len];
            for (int i = 0; i < len; ++i) {
                strings[i] = String.valueOf(Array.get(obj, i));
            }
            return Arrays.toString(strings);
        }
        return obj;
    }

    public static <T extends Annotation> List<Label> getLabels(Method method, Class<T> annotation, Function<T, List<Label>> extractor) {
        ArrayList<Label> labels = new ArrayList<Label>();
        labels.addAll(Allure1Utils.getLabels((AnnotatedElement)method, annotation, extractor));
        labels.addAll(Allure1Utils.getLabels(method.getDeclaringClass(), annotation, extractor));
        return labels;
    }

    private static <T extends Annotation> List<Label> getLabels(AnnotatedElement element, Class<T> annotation, Function<T, List<Label>> extractor) {
        return element.isAnnotationPresent(annotation) ? extractor.apply(element.getAnnotation(annotation)) : Collections.emptyList();
    }

    public static <T extends Annotation> List<Link> getLinks(Method method, Class<T> annotation, Function<T, List<Link>> extractor) {
        ArrayList<Link> labels = new ArrayList<Link>();
        labels.addAll(Allure1Utils.getLinks((AnnotatedElement)method, annotation, extractor));
        labels.addAll(Allure1Utils.getLinks(method.getDeclaringClass(), annotation, extractor));
        return labels;
    }

    private static <T extends Annotation> List<Link> getLinks(AnnotatedElement element, Class<T> annotation, Function<T, List<Link>> extractor) {
        return element.isAnnotationPresent(annotation) ? extractor.apply(element.getAnnotation(annotation)) : Collections.emptyList();
    }

    public static List<Label> createLabels(Stories stories) {
        return Arrays.stream(stories.value()).map(value -> new Label().setName(STORY_LABEL).setValue(value)).collect(Collectors.toList());
    }

    public static List<Label> createLabels(Features features) {
        return Arrays.stream(features.value()).map(value -> new Label().setName(FEATURE_LABEL).setValue(value)).collect(Collectors.toList());
    }

    public static List<Label> createLabels(Severity severity) {
        return Collections.singletonList(new Label().setName(SEVERITY_LABEL).setValue(severity.value().value()));
    }

    public static List<Link> createLinks(Issues issues) {
        return Arrays.stream(issues.value()).map(Allure1Utils::createLink).collect(Collectors.toList());
    }

    public static List<Link> createLinks(Issue issue) {
        return Collections.singletonList(Allure1Utils.createLink(issue));
    }

    public static List<Link> createLinks(TestCaseId issue) {
        return Collections.singletonList(ResultsUtils.createTmsLink((String)issue.value()));
    }

    private static Link createLink(Issue issue) {
        return ResultsUtils.createIssueLink((String)issue.value());
    }
}

