/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.jbehave5;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Step;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.NullStoryReporter;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.Timing;

public class AllureJbehave5
extends NullStoryReporter {
    private final AllureLifecycle lifecycle;
    private final ThreadLocal<Story> currentStory = new InheritableThreadLocal<Story>();
    private final ThreadLocal<Scenario> currentScenario = new InheritableThreadLocal<Scenario>();
    private final Map<Scenario, List<String>> scenarioUuids = new ConcurrentHashMap<Scenario, List<String>>();
    private final ThreadLocal<Deque<Story>> givenStories = ThreadLocal.withInitial(LinkedList::new);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public AllureJbehave5() {
        this(Allure.getLifecycle());
    }

    public AllureJbehave5(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void beforeStory(Story story, boolean givenStory) {
        if (givenStory) {
            this.givenStories.get().push(story);
        } else {
            this.currentStory.set(story);
        }
    }

    public void afterStory(boolean givenStory) {
        if (givenStory) {
            this.givenStories.get().pop();
        } else {
            this.currentStory.remove();
        }
    }

    public void beforeScenario(Scenario scenario) {
        if (this.isGivenStory()) {
            return;
        }
        this.currentScenario.set(scenario);
        if (this.notParameterised(scenario)) {
            String uuid = UUID.randomUUID().toString();
            this.usingWriteLock(() -> this.scenarioUuids.put(scenario, new ArrayList<String>(Collections.singletonList(uuid))));
            this.startTestCase(uuid, scenario, Collections.emptyMap());
        } else {
            this.usingWriteLock(() -> this.scenarioUuids.put(scenario, new ArrayList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        if (this.isGivenStory()) {
            return;
        }
        Scenario scenario = this.currentScenario.get();
        this.lock.writeLock().lock();
        try {
            this.scenarioUuids.put(scenario, new ArrayList());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void example(Map<String, String> tableRow, int exampleIndex) {
        if (this.isGivenStory()) {
            return;
        }
        Scenario scenario = this.currentScenario.get();
        String uuid = UUID.randomUUID().toString();
        this.usingWriteLock(() -> ((List)this.scenarioUuids.getOrDefault(scenario, new ArrayList())).add(uuid));
        this.startTestCase(uuid, scenario, tableRow);
    }

    public void afterScenario(Timing timing) {
        if (this.isGivenStory()) {
            return;
        }
        Scenario scenario = this.currentScenario.get();
        this.usingReadLock(() -> {
            List<String> uuids = this.scenarioUuids.getOrDefault(scenario, Collections.emptyList());
            uuids.forEach(this::stopTestCase);
        });
        this.currentScenario.remove();
        this.usingWriteLock(() -> this.scenarioUuids.remove(scenario));
    }

    public void beforeStep(Step step) {
        String stepUuid = UUID.randomUUID().toString();
        this.getLifecycle().startStep(stepUuid, new StepResult().setName(step.getStepAsString()));
    }

    public void successful(String step) {
        this.getLifecycle().updateTestCase(result -> result.setStatus(Status.PASSED));
        this.getLifecycle().updateStep(result -> result.setStatus(Status.PASSED));
        this.getLifecycle().stopStep();
    }

    public void ignorable(String step) {
        this.getLifecycle().stopStep();
    }

    public void pending(StepCreator.PendingStep step) {
        this.getLifecycle().updateStep(result -> result.setStatus(Status.SKIPPED));
        this.getLifecycle().stopStep();
    }

    public void notPerformed(String step) {
        this.getLifecycle().stopStep();
    }

    public void failed(String step, Throwable cause) {
        Throwable unwrapped = cause instanceof UUIDExceptionWrapper ? cause.getCause() : cause;
        Status status = ResultsUtils.getStatus((Throwable)unwrapped).orElse(Status.FAILED);
        StatusDetails statusDetails = ResultsUtils.getStatusDetails((Throwable)unwrapped).orElseGet(StatusDetails::new);
        this.getLifecycle().updateStep(result -> {
            result.setStatus(status);
            result.setStatusDetails(statusDetails);
        });
        this.getLifecycle().updateTestCase(result -> {
            result.setStatus(status);
            result.setStatusDetails(statusDetails);
        });
        this.getLifecycle().stopStep();
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    protected void startTestCase(String uuid, Scenario scenario, Map<String, String> tableRow) {
        Story story = this.currentStory.get();
        String name = scenario.getTitle();
        String fullName = String.format("%s: %s", story.getName(), name);
        List<Parameter> parameters = tableRow.entrySet().stream().map(entry -> ResultsUtils.createParameter((String)((String)entry.getKey()), entry.getValue())).collect(Collectors.toList());
        ArrayList<Label> labels = new ArrayList<Label>(Arrays.asList(ResultsUtils.createStoryLabel((String)story.getName()), ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createFrameworkLabel((String)"jbehave"), ResultsUtils.createLanguageLabel((String)"java")));
        labels.addAll(ResultsUtils.getProvidedLabels());
        String historyId = this.getHistoryId(fullName, parameters);
        TestResult result = new TestResult().setUuid(uuid).setName(name).setFullName(fullName).setStage(Stage.SCHEDULED).setLabels(labels).setParameters(parameters).setDescription(story.getDescription().asString()).setHistoryId(historyId);
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().startTestCase(result.getUuid());
    }

    protected void stopTestCase(String uuid) {
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    protected boolean notParameterised(Scenario scenario) {
        return scenario.getExamplesTable().getRowCount() == 0;
    }

    protected String getHistoryId(String fullName, List<Parameter> parameters) {
        MessageDigest digest = ResultsUtils.getMd5Digest();
        digest.update(fullName.getBytes(StandardCharsets.UTF_8));
        parameters.stream().sorted(Comparator.comparing(Parameter::getName).thenComparing(Parameter::getValue)).forEachOrdered(parameter -> {
            digest.update(parameter.getName().getBytes(StandardCharsets.UTF_8));
            digest.update(parameter.getValue().getBytes(StandardCharsets.UTF_8));
        });
        byte[] bytes = digest.digest();
        return ResultsUtils.bytesToHex((byte[])bytes);
    }

    private boolean isGivenStory() {
        return !this.givenStories.get().isEmpty();
    }

    private void usingReadLock(Runnable runnable) {
        this.lock.readLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void usingWriteLock(Runnable runnable) {
        this.lock.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

