/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junitplatform;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Description;
import io.qameta.allure.Severity;
import io.qameta.allure.SeverityLevel;
import io.qameta.allure.model.ExecutableItem;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.util.AnnotationUtils;
import io.qameta.allure.util.ResultsUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.DisplayName;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureJunitPlatform
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureJunitPlatform.class);
    public static final String ALLURE_FIXTURE = "allure.fixture";
    public static final String PREPARE = "prepare";
    public static final String TEAR_DOWN = "tear_down";
    public static final String EVENT_START = "start";
    public static final String EVENT_STOP = "stop";
    public static final String EVENT_FAILURE = "failure";
    private static final String STDOUT = "stdout";
    private static final String STDERR = "stderr";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TXT_EXTENSION = ".txt";
    private final ThreadLocal<TestPlan> testPlanStorage = new InheritableThreadLocal<TestPlan>();
    private final Uuids tests = new Uuids();
    private final Uuids containers = new Uuids();
    private final AllureLifecycle lifecycle;

    public AllureJunitPlatform(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureJunitPlatform() {
        this.lifecycle = Allure.getLifecycle();
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlanStorage.set(testPlan);
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlanStorage.remove();
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (!testIdentifier.getParentId().isPresent()) {
            return;
        }
        this.startTestContainer(testIdentifier);
        if (testIdentifier.isTest()) {
            this.startTestCase(testIdentifier);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (!testIdentifier.getParentId().isPresent()) {
            return;
        }
        Status status = this.extractStatus(testExecutionResult);
        StatusDetails statusDetails = testExecutionResult.getThrowable().flatMap(ResultsUtils::getStatusDetails).orElse(null);
        if (testIdentifier.isTest()) {
            this.stopTestCase(testIdentifier, status, statusDetails);
        } else if (testExecutionResult.getStatus() != TestExecutionResult.Status.SUCCESSFUL) {
            this.startTestCase(testIdentifier);
            this.stopTestCase(testIdentifier, status, statusDetails);
        }
        this.stopTestContainer(testIdentifier);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (!testIdentifier.getParentId().isPresent()) {
            return;
        }
        TestPlan testPlan = this.testPlanStorage.get();
        if (Objects.isNull(testPlan)) {
            return;
        }
        this.reportNested(testPlan, testIdentifier, Status.SKIPPED, new StatusDetails().setMessage(reason), new HashSet<TestIdentifier>());
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        String content;
        Map keyValuePairs = entry.getKeyValuePairs();
        if (keyValuePairs.containsKey(ALLURE_FIXTURE)) {
            String type = (String)keyValuePairs.get(ALLURE_FIXTURE);
            String event = (String)keyValuePairs.get("event");
            if (Objects.isNull(type) || Objects.isNull(event)) {
                return;
            }
            switch (event) {
                case "start": {
                    Optional<String> maybeParent = this.containers.get(testIdentifier);
                    if (!maybeParent.isPresent()) {
                        return;
                    }
                    String parentUuid = maybeParent.get();
                    this.startFixture(parentUuid, type, keyValuePairs);
                    return;
                }
                case "failure": {
                    this.failFixture(keyValuePairs);
                    this.resetContext(testIdentifier);
                    return;
                }
                case "stop": {
                    this.stopFixture(keyValuePairs);
                    this.resetContext(testIdentifier);
                    return;
                }
            }
            return;
        }
        if (keyValuePairs.containsKey(STDOUT)) {
            content = keyValuePairs.getOrDefault(STDOUT, "");
            this.getLifecycle().addAttachment("Stdout", TEXT_PLAIN, TXT_EXTENSION, content.getBytes(StandardCharsets.UTF_8));
        }
        if (keyValuePairs.containsKey(STDERR)) {
            content = keyValuePairs.getOrDefault(STDERR, "");
            this.getLifecycle().addAttachment("Stderr", TEXT_PLAIN, TXT_EXTENSION, content.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void resetContext(TestIdentifier testIdentifier) {
        Optional.of(testIdentifier).filter(TestIdentifier::isTest).flatMap(this.tests::get).ifPresent(arg_0 -> ((AllureLifecycle)Allure.getLifecycle()).setCurrentTestCase(arg_0));
    }

    private void reportNested(TestPlan testPlan, TestIdentifier testIdentifier, Status status, StatusDetails statusDetails, Set<TestIdentifier> visited) {
        Set children = testPlan.getChildren(testIdentifier);
        if (testIdentifier.isTest() || children.isEmpty()) {
            this.startTestCase(testIdentifier);
            this.stopTestCase(testIdentifier, status, statusDetails);
        }
        visited.add(testIdentifier);
        children.stream().filter(id -> !visited.contains(id)).forEach(child -> this.reportNested(testPlan, (TestIdentifier)child, status, statusDetails, visited));
    }

    protected Status getStatus(Throwable throwable) {
        return ResultsUtils.getStatus((Throwable)throwable).orElse(Status.FAILED);
    }

    private void startTestContainer(TestIdentifier testIdentifier) {
        String uuid = this.containers.getOrCreate(testIdentifier);
        TestResultContainer result = new TestResultContainer().setUuid(uuid).setName(testIdentifier.getDisplayName());
        this.getLifecycle().startTestContainer(result);
    }

    private void stopTestContainer(TestIdentifier testIdentifier) {
        Optional<String> maybeUuid = this.containers.get(testIdentifier);
        if (!maybeUuid.isPresent()) {
            return;
        }
        String uuid = maybeUuid.get();
        TestPlan context = this.testPlanStorage.get();
        Set children = Optional.ofNullable(context).map(tp -> tp.getDescendants(testIdentifier)).orElseGet(Collections::emptySet).stream().filter(TestIdentifier::isTest).map(this.tests::get).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(HashSet::new));
        if (testIdentifier.isTest()) {
            this.tests.get(testIdentifier).ifPresent(children::add);
        }
        this.getLifecycle().updateTestContainer(uuid, container -> container.setChildren((Collection)children));
        this.getLifecycle().stopTestContainer(uuid);
        this.getLifecycle().writeTestContainer(uuid);
    }

    private void startFixture(String parentUuid, String type, Map<String, String> keyValue) {
        String uuid = keyValue.get("uuid");
        if (Objects.isNull(uuid)) {
            return;
        }
        String name = keyValue.getOrDefault("name", "Unknown");
        FixtureResult result = new FixtureResult().setName(name);
        switch (type) {
            case "prepare": {
                this.getLifecycle().startPrepareFixture(parentUuid, uuid, result);
                return;
            }
            case "tear_down": {
                this.getLifecycle().startTearDownFixture(parentUuid, uuid, result);
                return;
            }
        }
        LOGGER.debug("unknown fixture type {}", (Object)type);
    }

    private void failFixture(Map<String, String> keyValue) {
        String uuid = keyValue.get("uuid");
        if (Objects.isNull(uuid)) {
            return;
        }
        this.getLifecycle().updateFixture(uuid, fixtureResult -> {
            Optional.of(keyValue.get("status")).map(Status::fromValue).ifPresent(arg_0 -> ((FixtureResult)fixtureResult).setStatus(arg_0));
            fixtureResult.setStatusDetails(new StatusDetails());
            Optional.of(keyValue.get("message")).ifPresent(arg_0 -> ((StatusDetails)fixtureResult.getStatusDetails()).setMessage(arg_0));
            Optional.of(keyValue.get("trace")).ifPresent(arg_0 -> ((StatusDetails)fixtureResult.getStatusDetails()).setTrace(arg_0));
        });
        this.getLifecycle().stopFixture(uuid);
    }

    private void stopFixture(Map<String, String> keyValue) {
        String uuid = keyValue.get("uuid");
        if (Objects.isNull(uuid)) {
            return;
        }
        this.getLifecycle().updateFixture(uuid, fixtureResult -> fixtureResult.setStatus(Status.PASSED));
        this.getLifecycle().stopFixture(uuid);
    }

    private void startTestCase(TestIdentifier testIdentifier) {
        String uuid = this.tests.getOrCreate(testIdentifier);
        Optional testSource = testIdentifier.getSource();
        Optional<Object> testMethod = testSource.flatMap(this::getTestMethod);
        Optional<Set> testClass = testSource.flatMap(this::getTestClass);
        TestResult result = new TestResult().setUuid(uuid).setName(testIdentifier.getDisplayName()).setLabels(this.getTags(testIdentifier)).setHistoryId(this.getHistoryId(testIdentifier)).setStage(Stage.RUNNING);
        result.getLabels().addAll(ResultsUtils.getProvidedLabels());
        testClass.map(AnnotationUtils::getLabels).ifPresent(result.getLabels()::addAll);
        testMethod.map(AnnotationUtils::getLabels).ifPresent(result.getLabels()::addAll);
        testClass.map(AnnotationUtils::getLinks).ifPresent(result.getLinks()::addAll);
        testMethod.map(AnnotationUtils::getLinks).ifPresent(result.getLinks()::addAll);
        result.getLabels().addAll(Arrays.asList(ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createFrameworkLabel((String)"junit-platform"), ResultsUtils.createLanguageLabel((String)"java")));
        testSource.flatMap(this::getFullName).ifPresent(arg_0 -> ((TestResult)result).setFullName(arg_0));
        testSource.map(this::getSourceLabels).ifPresent(result.getLabels()::addAll);
        testClass.ifPresent(aClass -> {
            String suiteName = this.getDisplayName((AnnotatedElement)aClass).orElse(aClass.getCanonicalName());
            result.getLabels().add(ResultsUtils.createSuiteLabel((String)suiteName));
        });
        Optional classDescription = testClass.flatMap(this::getDescription);
        Optional methodDescription = testMethod.flatMap(this::getDescription);
        String description = Stream.of(classDescription, methodDescription).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n\n"));
        result.setDescription(description);
        testMethod.map(this::getSeverity).filter(Optional::isPresent).orElse(testClass.flatMap(this::getSeverity)).map(ResultsUtils::createSeverityLabel).ifPresent(result.getLabels()::add);
        testMethod.ifPresent(method -> ResultsUtils.processDescription((ClassLoader)method.getDeclaringClass().getClassLoader(), (Method)method, (ExecutableItem)result));
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().startTestCase(uuid);
    }

    private void stopTestCase(TestIdentifier testIdentifier, Status status, StatusDetails statusDetails) {
        Optional<String> maybeUuid = this.tests.get(testIdentifier);
        if (!maybeUuid.isPresent()) {
            return;
        }
        String uuid = maybeUuid.get();
        this.getLifecycle().updateTestCase(uuid, result -> {
            result.setStage(Stage.FINISHED);
            result.setStatus(status);
            result.setStatusDetails(statusDetails);
        });
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    private Status extractStatus(TestExecutionResult testExecutionResult) {
        switch (testExecutionResult.getStatus()) {
            case FAILED: {
                return testExecutionResult.getThrowable().isPresent() ? this.getStatus((Throwable)testExecutionResult.getThrowable().get()) : Status.FAILED;
            }
            case SUCCESSFUL: {
                return Status.PASSED;
            }
        }
        return Status.SKIPPED;
    }

    private List<Label> getTags(TestIdentifier testIdentifier) {
        return testIdentifier.getTags().stream().map(TestTag::getName).map(ResultsUtils::createTagLabel).collect(Collectors.toList());
    }

    protected String getHistoryId(TestIdentifier testIdentifier) {
        return this.md5(testIdentifier.getUniqueId());
    }

    private String md5(String source) {
        byte[] bytes = ResultsUtils.getMd5Digest().digest(source.getBytes(StandardCharsets.UTF_8));
        return new BigInteger(1, bytes).toString(16);
    }

    private Optional<SeverityLevel> getSeverity(AnnotatedElement annotatedElement) {
        return this.getAnnotations(annotatedElement, Severity.class).map(Severity::value).findAny();
    }

    private Optional<String> getDisplayName(AnnotatedElement annotatedElement) {
        return this.getAnnotations(annotatedElement, DisplayName.class).map(DisplayName::value).findAny();
    }

    private Optional<String> getDescription(AnnotatedElement annotatedElement) {
        return this.getAnnotations(annotatedElement, Description.class).map(Description::value).findAny();
    }

    private <T extends Annotation> Stream<T> getAnnotations(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        return Stream.of(annotatedElement.getAnnotationsByType(annotationClass));
    }

    private List<Label> getSourceLabels(TestSource source) {
        if (source instanceof MethodSource) {
            MethodSource ms = (MethodSource)source;
            return Arrays.asList(ResultsUtils.createPackageLabel((String)ms.getClassName()), ResultsUtils.createTestClassLabel((String)ms.getClassName()), ResultsUtils.createTestMethodLabel((String)ms.getMethodName()));
        }
        if (source instanceof ClassSource) {
            ClassSource cs = (ClassSource)source;
            return Arrays.asList(ResultsUtils.createPackageLabel((String)cs.getClassName()), ResultsUtils.createTestClassLabel((String)cs.getClassName()));
        }
        return Collections.emptyList();
    }

    private Optional<String> getFullName(TestSource source) {
        if (source instanceof MethodSource) {
            MethodSource ms = (MethodSource)source;
            return Optional.of(String.format("%s.%s", ms.getClassName(), ms.getMethodName()));
        }
        if (source instanceof ClassSource) {
            ClassSource cs = (ClassSource)source;
            return Optional.ofNullable(cs.getClassName());
        }
        return Optional.empty();
    }

    private Optional<Class<?>> getTestClass(TestSource source) {
        if (source instanceof MethodSource) {
            return this.getTestClass(((MethodSource)source).getClassName());
        }
        if (source instanceof ClassSource) {
            return Optional.of(((ClassSource)source).getJavaClass());
        }
        return Optional.empty();
    }

    private Optional<Class<?>> getTestClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace("Could not get test class from test source {}", (Object)className, (Object)e);
            return Optional.empty();
        }
    }

    private Optional<Method> getTestMethod(TestSource source) {
        if (source instanceof MethodSource) {
            return this.getTestMethod((MethodSource)source);
        }
        return Optional.empty();
    }

    private Optional<Method> getTestMethod(MethodSource source) {
        try {
            Class<?> aClass = Class.forName(source.getClassName());
            return Stream.of(aClass.getDeclaredMethods()).filter(method -> MethodSource.from((Method)method).equals((Object)source)).findAny();
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace("Could not get test method from method source {}", (Object)source, (Object)e);
            return Optional.empty();
        }
    }

    private static class Uuids {
        private final Map<TestIdentifier, String> storage = new ConcurrentHashMap<TestIdentifier, String>();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        private Uuids() {
        }

        public Optional<String> get(TestIdentifier testIdentifier) {
            try {
                this.lock.readLock().lock();
                Optional<String> optional = Optional.ofNullable(this.storage.get(testIdentifier));
                return optional;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private String getOrCreate(TestIdentifier testIdentifier) {
            try {
                this.lock.writeLock().lock();
                String string = this.storage.computeIfAbsent(testIdentifier, ti -> UUID.randomUUID().toString());
                return string;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

