/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junitplatform;

import io.qameta.allure.junitplatform.AllureJunitPlatformUtils;
import io.qameta.allure.model.Label;
import io.qameta.allure.testfilter.FileTestPlanSupplier;
import io.qameta.allure.testfilter.TestPlan;
import io.qameta.allure.testfilter.TestPlanV1_0;
import io.qameta.allure.util.AnnotationUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.launcher.PostDiscoveryFilter;

public class AllurePostDiscoveryFilter
implements PostDiscoveryFilter {
    private static final Pattern ID_TAG = Pattern.compile("^@?allure\\.id[:=](?<id>.+)$");
    private final TestPlan testPlan;

    public AllurePostDiscoveryFilter() {
        this(new FileTestPlanSupplier().supply().orElse(null));
    }

    public AllurePostDiscoveryFilter(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public FilterResult apply(TestDescriptor object) {
        if (Objects.isNull(this.testPlan)) {
            return FilterResult.included((String)"test plan is empty");
        }
        if (!object.getChildren().isEmpty()) {
            return FilterResult.included((String)"filter only applied for tests");
        }
        String allureId = this.findAllureId(object);
        String uniqueId = object.getUniqueId().toString();
        String fullName = object.getSource().flatMap(AllureJunitPlatformUtils::getFullName).orElse(null);
        return FilterResult.includedIf((boolean)this.isIncluded(this.testPlan, allureId, uniqueId, fullName));
    }

    private boolean isIncluded(TestPlan testPlan, String allureId, String uniqueId, String fullName) {
        if (testPlan instanceof TestPlanV1_0) {
            TestPlanV1_0 tp = (TestPlanV1_0)testPlan;
            return Objects.isNull(tp.getTests()) || tp.getTests().stream().filter(Objects::nonNull).anyMatch(tc -> this.match((TestPlanV1_0.TestCase)tc, allureId, uniqueId, fullName));
        }
        return true;
    }

    private boolean match(TestPlanV1_0.TestCase tc, String allureId, String uniqueId, String fullName) {
        return Objects.nonNull(tc.getId()) && tc.getId().equals(allureId) || Objects.nonNull(tc.getSelector()) && tc.getSelector().equals(uniqueId) || Objects.nonNull(tc.getSelector()) && tc.getSelector().equals(fullName);
    }

    private String findAllureId(TestDescriptor object) {
        return object.getSource().flatMap(AllureJunitPlatformUtils::getTestMethod).flatMap(this::findAllureId).orElseGet(() -> this.findAllureId(object.getTags()));
    }

    private String findAllureId(Collection<TestTag> tags) {
        return tags.stream().map(TestTag::getName).map(t -> {
            Matcher matcher = ID_TAG.matcher((CharSequence)t);
            return matcher.matches() ? Optional.ofNullable(matcher.group("id")) : Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).filter(Objects::nonNull).findAny().orElse(null);
    }

    private Optional<String> findAllureId(Method value) {
        return AnnotationUtils.getLabels((AnnotatedElement)value).stream().filter(l -> "AS_ID".equals(l.getName())).map(Label::getValue).findAny();
    }
}

