/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junitplatform;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Description;
import io.qameta.allure.Epic;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Link;
import io.qameta.allure.Owner;
import io.qameta.allure.Severity;
import io.qameta.allure.SeverityLevel;
import io.qameta.allure.Story;
import io.qameta.allure.TmsLink;
import io.qameta.allure.model.ExecutableItem;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.DisplayName;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureJunitPlatform
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureJunitPlatform.class);
    private static final String STDOUT = "stdout";
    private static final String STDERR = "stderr";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TXT_EXTENSION = ".txt";
    private final ThreadLocal<TestPlan> testPlanStorage = new InheritableThreadLocal<TestPlan>();
    private final Map<TestIdentifier, String> testUuids = new ConcurrentHashMap<TestIdentifier, String>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AllureLifecycle lifecycle;

    public AllureJunitPlatform(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureJunitPlatform() {
        this.lifecycle = Allure.getLifecycle();
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlanStorage.set(testPlan);
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlanStorage.remove();
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.startTestCase(testIdentifier);
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (testIdentifier.isTest()) {
            this.startTestCase(testIdentifier);
            this.stopTestCase(testIdentifier, Status.SKIPPED, new StatusDetails().setMessage(reason));
            return;
        }
        TestPlan testPlan = this.testPlanStorage.get();
        if (Objects.nonNull(testPlan)) {
            Set children = testPlan.getChildren(testIdentifier);
            if (children.isEmpty()) {
                this.startTestCase(testIdentifier);
                this.stopTestCase(testIdentifier, Status.SKIPPED, new StatusDetails().setMessage(reason));
                return;
            }
            HashSet<TestIdentifier> visited = new HashSet<TestIdentifier>(Collections.singleton(testIdentifier));
            children.forEach(child -> this.executionSkipped(testPlan, (TestIdentifier)child, reason, (Set<TestIdentifier>)visited));
        }
    }

    private void executionSkipped(TestPlan testPlan, TestIdentifier testIdentifier, String reason, Set<TestIdentifier> visited) {
        if (testIdentifier.isTest()) {
            this.startTestCase(testIdentifier);
            this.stopTestCase(testIdentifier, Status.SKIPPED, new StatusDetails().setMessage(reason));
            return;
        }
        Set children = testPlan.getChildren(testIdentifier);
        children.stream().filter(visited::add).forEach(child -> this.executionSkipped(testPlan, (TestIdentifier)child, reason, visited));
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            Status status = this.extractStatus(testExecutionResult);
            StatusDetails statusDetails = testExecutionResult.getThrowable().flatMap(ResultsUtils::getStatusDetails).orElse(null);
            this.stopTestCase(testIdentifier, status, statusDetails);
        }
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        String content;
        String uuid = this.getUuid(testIdentifier);
        if (Objects.isNull(uuid)) {
            return;
        }
        Map keyValuePairs = entry.getKeyValuePairs();
        if (keyValuePairs.containsKey(STDOUT)) {
            content = keyValuePairs.getOrDefault(STDOUT, "");
            this.getLifecycle().addAttachment("Stdout", TEXT_PLAIN, TXT_EXTENSION, content.getBytes(StandardCharsets.UTF_8));
        }
        if (keyValuePairs.containsKey(STDERR)) {
            content = keyValuePairs.getOrDefault(STDERR, "");
            this.getLifecycle().addAttachment("Stderr", TEXT_PLAIN, TXT_EXTENSION, content.getBytes(StandardCharsets.UTF_8));
        }
    }

    protected Status getStatus(Throwable throwable) {
        return ResultsUtils.getStatus((Throwable)throwable).orElse(Status.FAILED);
    }

    private void startTestCase(TestIdentifier testIdentifier) {
        String uuid = this.createUuid(testIdentifier);
        Optional<MethodSource> methodSource = testIdentifier.getSource().filter(MethodSource.class::isInstance).map(MethodSource.class::cast);
        Optional<Object> testMethod = methodSource.flatMap(this::getTestMethod);
        Optional<List> testClass = methodSource.flatMap(this::getTestClass);
        TestResult result = new TestResult().setUuid(uuid).setName(testIdentifier.getDisplayName()).setLabels(this.getTags(testIdentifier)).setHistoryId(this.getHistoryId(testIdentifier)).setStage(Stage.RUNNING);
        testClass.map(this::getLabels).ifPresent(result.getLabels()::addAll);
        testMethod.map(this::getLabels).ifPresent(result.getLabels()::addAll);
        testClass.map(this::getLinks).ifPresent(result.getLinks()::addAll);
        testMethod.map(this::getLinks).ifPresent(result.getLinks()::addAll);
        result.getLabels().add(ResultsUtils.createHostLabel());
        result.getLabels().add(ResultsUtils.createThreadLabel());
        methodSource.ifPresent(source -> {
            result.setFullName(String.format("%s.%s", source.getClassName(), source.getMethodName()));
            result.getLabels().add(ResultsUtils.createPackageLabel((String)source.getClassName()));
            result.getLabels().add(ResultsUtils.createTestClassLabel((String)source.getClassName()));
            result.getLabels().add(ResultsUtils.createTestMethodLabel((String)source.getMethodName()));
        });
        testClass.ifPresent(aClass -> {
            String suiteName = this.getDisplayName((AnnotatedElement)aClass).orElse(aClass.getCanonicalName());
            result.getLabels().add(ResultsUtils.createSuiteLabel((String)suiteName));
        });
        Optional classDescription = testClass.flatMap(this::getDescription);
        Optional methodDescription = testMethod.flatMap(this::getDescription);
        String description = Stream.of(classDescription, methodDescription).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n\n"));
        result.setDescription(description);
        testMethod.map(this::getSeverity).filter(Optional::isPresent).orElse(testClass.flatMap(this::getSeverity)).map(ResultsUtils::createSeverityLabel).ifPresent(result.getLabels()::add);
        testMethod.map(this::getOwner).filter(Optional::isPresent).orElse(testClass.flatMap(this::getOwner)).map(ResultsUtils::createOwnerLabel).ifPresent(result.getLabels()::add);
        testMethod.ifPresent(method -> ResultsUtils.processDescription((ClassLoader)method.getDeclaringClass().getClassLoader(), (Method)method, (ExecutableItem)result));
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().startTestCase(uuid);
    }

    private void stopTestCase(TestIdentifier testIdentifier, Status status, StatusDetails statusDetails) {
        String uuid = this.removeUuid(testIdentifier);
        this.getLifecycle().updateTestCase(uuid, result -> {
            result.setStage(Stage.FINISHED);
            result.setStatus(status);
            result.setStatusDetails(statusDetails);
        });
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    private String createUuid(TestIdentifier testIdentifier) {
        String uuid = UUID.randomUUID().toString();
        try {
            this.lock.writeLock().lock();
            this.testUuids.put(testIdentifier, uuid);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return uuid;
    }

    private String getUuid(TestIdentifier testIdentifier) {
        try {
            this.lock.readLock().lock();
            String string = this.testUuids.get(testIdentifier);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private String removeUuid(TestIdentifier testIdentifier) {
        try {
            this.lock.writeLock().lock();
            String string = this.testUuids.remove(testIdentifier);
            return string;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private Status extractStatus(TestExecutionResult testExecutionResult) {
        switch (testExecutionResult.getStatus()) {
            case FAILED: {
                return testExecutionResult.getThrowable().isPresent() ? this.getStatus((Throwable)testExecutionResult.getThrowable().get()) : Status.FAILED;
            }
            case SUCCESSFUL: {
                return Status.PASSED;
            }
        }
        return Status.SKIPPED;
    }

    private List<Label> getTags(TestIdentifier testIdentifier) {
        return testIdentifier.getTags().stream().map(TestTag::getName).map(ResultsUtils::createTagLabel).collect(Collectors.toList());
    }

    protected String getHistoryId(TestIdentifier testIdentifier) {
        return this.md5(testIdentifier.getUniqueId());
    }

    private String md5(String source) {
        byte[] bytes = ResultsUtils.getMd5Digest().digest(source.getBytes(StandardCharsets.UTF_8));
        return new BigInteger(1, bytes).toString(16);
    }

    private Optional<SeverityLevel> getSeverity(AnnotatedElement annotatedElement) {
        return this.getAnnotations(annotatedElement, Severity.class).map(Severity::value).findAny();
    }

    private Optional<String> getOwner(AnnotatedElement annotatedElement) {
        return this.getAnnotations(annotatedElement, Owner.class).map(Owner::value).findAny();
    }

    private Optional<String> getDisplayName(AnnotatedElement annotatedElement) {
        return this.getAnnotations(annotatedElement, DisplayName.class).map(DisplayName::value).findAny();
    }

    private Optional<String> getDescription(AnnotatedElement annotatedElement) {
        return this.getAnnotations(annotatedElement, Description.class).map(Description::value).findAny();
    }

    private List<Label> getLabels(AnnotatedElement annotatedElement) {
        return Stream.of(this.getAnnotations(annotatedElement, Epic.class).map(ResultsUtils::createLabel), this.getAnnotations(annotatedElement, Feature.class).map(ResultsUtils::createLabel), this.getAnnotations(annotatedElement, Story.class).map(ResultsUtils::createLabel)).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private List<io.qameta.allure.model.Link> getLinks(AnnotatedElement annotatedElement) {
        return Stream.of(this.getAnnotations(annotatedElement, Link.class).map(ResultsUtils::createLink), this.getAnnotations(annotatedElement, Issue.class).map(ResultsUtils::createLink), this.getAnnotations(annotatedElement, TmsLink.class).map(ResultsUtils::createLink)).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private <T extends Annotation> Stream<T> getAnnotations(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        T annotation = annotatedElement.getAnnotation(annotationClass);
        return Stream.concat(this.extractRepeatable(annotatedElement, annotationClass).stream(), Objects.isNull(annotation) ? Stream.empty() : Stream.of(annotation));
    }

    private <T extends Annotation> List<T> extractRepeatable(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        Repeatable repeatable;
        Class<? extends Annotation> wrapper;
        Annotation annotation;
        if (annotationClass.isAnnotationPresent(Repeatable.class) && Objects.nonNull(annotation = annotatedElement.getAnnotation(wrapper = (repeatable = annotationClass.getAnnotation(Repeatable.class)).value()))) {
            try {
                Method value = annotation.getClass().getMethod("value", new Class[0]);
                Object annotations = value.invoke((Object)annotation, new Object[0]);
                return Arrays.asList((Annotation[])annotations);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return Collections.emptyList();
    }

    private Optional<Class<?>> getTestClass(MethodSource source) {
        try {
            return Optional.of(Class.forName(source.getClassName()));
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace("Could not get test class from method source {}", (Object)source, (Object)e);
            return Optional.empty();
        }
    }

    private Optional<Method> getTestMethod(MethodSource source) {
        try {
            Class<?> aClass = Class.forName(source.getClassName());
            return Stream.of(aClass.getDeclaredMethods()).filter(method -> MethodSource.from((Method)method).equals((Object)source)).findAny();
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace("Could not get test method from method source {}", (Object)source, (Object)e);
            return Optional.empty();
        }
    }
}

