/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit4;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Description;
import io.qameta.allure.junit4.AllureJunit4Utils;
import io.qameta.allure.junit4.DisplayName;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.AnnotationUtils;
import io.qameta.allure.util.ResultsUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Ignore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@RunListener.ThreadSafe
public class AllureJunit4
extends RunListener {
    private static final boolean HAS_CUCUMBERJVM7_IN_CLASSPATH = AllureJunit4.isClassAvailableOnClasspath("io.qameta.allure.cucumber7jvm.AllureCucumber7Jvm");
    private static final boolean HAS_CUCUMBERJVM6_IN_CLASSPATH = AllureJunit4.isClassAvailableOnClasspath("io.qameta.allure.cucumber6jvm.AllureCucumber6Jvm");
    private static final boolean HAS_CUCUMBERJVM5_IN_CLASSPATH = AllureJunit4.isClassAvailableOnClasspath("io.qameta.allure.cucumber5jvm.AllureCucumber5Jvm");
    private static final boolean HAS_CUCUMBERJVM4_IN_CLASSPATH = AllureJunit4.isClassAvailableOnClasspath("io.qameta.allure.cucumber4jvm.AllureCucumber4Jvm");
    private final ThreadLocal<String> testCases = new InheritableThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return UUID.randomUUID().toString();
        }
    };
    private final AllureLifecycle lifecycle;

    public AllureJunit4() {
        this(Allure.getLifecycle());
    }

    public AllureJunit4(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void testRunStarted(org.junit.runner.Description description) {
    }

    public void testRunFinished(Result result) {
    }

    public void testStarted(org.junit.runner.Description description) {
        if (this.shouldIgnore(description)) {
            return;
        }
        String uuid = this.testCases.get();
        TestResult result = this.createTestResult(uuid, description);
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().startTestCase(uuid);
    }

    public void testFinished(org.junit.runner.Description description) {
        if (this.shouldIgnore(description)) {
            return;
        }
        String uuid = this.testCases.get();
        this.testCases.remove();
        this.getLifecycle().updateTestCase(uuid, testResult -> {
            if (Objects.isNull(testResult.getStatus())) {
                testResult.setStatus(Status.PASSED);
            }
        });
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    public void testFailure(Failure failure) {
        if (this.shouldIgnore(failure.getDescription())) {
            return;
        }
        String uuid = this.testCases.get();
        this.getLifecycle().updateTestCase(uuid, testResult -> testResult.setStatus((Status)ResultsUtils.getStatus((Throwable)failure.getException()).orElse(null)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)failure.getException()).orElse(null)));
    }

    public void testAssumptionFailure(Failure failure) {
        if (this.shouldIgnore(failure.getDescription())) {
            return;
        }
        String uuid = this.testCases.get();
        this.getLifecycle().updateTestCase(uuid, testResult -> testResult.setStatus(Status.SKIPPED).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)failure.getException()).orElse(null)));
    }

    public void testIgnored(org.junit.runner.Description description) {
        if (this.shouldIgnore(description)) {
            return;
        }
        String uuid = this.testCases.get();
        this.testCases.remove();
        TestResult result = this.createTestResult(uuid, description);
        result.setStatus(Status.SKIPPED);
        result.setStatusDetails(this.getIgnoredMessage(description));
        result.setStart(Long.valueOf(System.currentTimeMillis()));
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    private Optional<String> getDisplayName(org.junit.runner.Description result) {
        return Optional.ofNullable((DisplayName)result.getAnnotation(DisplayName.class)).map(DisplayName::value);
    }

    private Optional<String> getDescription(org.junit.runner.Description result) {
        Description annotation = (Description)result.getAnnotation(Description.class);
        if (Objects.isNull(annotation)) {
            return Optional.empty();
        }
        if (!"".equals(annotation.value())) {
            return Optional.of(annotation.value());
        }
        Class testClass = result.getTestClass();
        String methodName = result.getMethodName();
        if (Objects.nonNull(testClass) && Objects.nonNull(methodName)) {
            List found = Stream.of(testClass.getMethods()).filter(method -> Objects.equals(methodName, method.getName())).collect(Collectors.toList());
            if (found.size() != 1) {
                return Optional.empty();
            }
            Method method2 = (Method)found.get(0);
            return ResultsUtils.getJavadocDescription((ClassLoader)method2.getDeclaringClass().getClassLoader(), (Method)method2);
        }
        return Optional.empty();
    }

    private List<Link> extractLinks(org.junit.runner.Description description) {
        ArrayList<Link> result = new ArrayList<Link>(AnnotationUtils.getLinks((Collection)description.getAnnotations()));
        Optional.of(description).map(org.junit.runner.Description::getTestClass).map(AnnotationUtils::getLinks).ifPresent(result::addAll);
        return result;
    }

    private List<Label> extractLabels(org.junit.runner.Description description) {
        ArrayList<Label> result = new ArrayList<Label>(AnnotationUtils.getLabels((Collection)description.getAnnotations()));
        Optional.of(description).map(org.junit.runner.Description::getTestClass).map(AnnotationUtils::getLabels).ifPresent(result::addAll);
        return result;
    }

    private String getHistoryId(org.junit.runner.Description description) {
        return ResultsUtils.md5((String)(description.getClassName() + description.getMethodName()));
    }

    private String getPackage(Class<?> testClass) {
        return Optional.ofNullable(testClass).map(Class::getPackage).map(Package::getName).orElse("");
    }

    private StatusDetails getIgnoredMessage(org.junit.runner.Description description) {
        Ignore ignore = (Ignore)description.getAnnotation(Ignore.class);
        String message = Objects.nonNull(ignore) && !ignore.value().isEmpty() ? ignore.value() : "Test ignored (without reason)!";
        return new StatusDetails().setMessage(message);
    }

    private TestResult createTestResult(String uuid, org.junit.runner.Description description) {
        String className = description.getClassName();
        String methodName = description.getMethodName();
        String name = Objects.nonNull(methodName) ? methodName : className;
        String fullName = AllureJunit4Utils.getFullName(description);
        String suite = Optional.ofNullable(description.getTestClass()).map(it -> it.getAnnotation(DisplayName.class)).map(DisplayName::value).orElse(className);
        TestResult testResult = new TestResult().setUuid(uuid).setHistoryId(this.getHistoryId(description)).setFullName(fullName).setName(name);
        testResult.getLabels().addAll(ResultsUtils.getProvidedLabels());
        testResult.getLabels().addAll(Arrays.asList(ResultsUtils.createPackageLabel((String)this.getPackage(description.getTestClass())), ResultsUtils.createTestClassLabel((String)className), ResultsUtils.createTestMethodLabel((String)name), ResultsUtils.createSuiteLabel((String)suite), ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createFrameworkLabel((String)"junit4"), ResultsUtils.createLanguageLabel((String)"java")));
        testResult.getLabels().addAll(this.extractLabels(description));
        testResult.getLinks().addAll(this.extractLinks(description));
        this.getDisplayName(description).ifPresent(arg_0 -> ((TestResult)testResult).setName(arg_0));
        this.getDescription(description).ifPresent(arg_0 -> ((TestResult)testResult).setDescription(arg_0));
        return testResult;
    }

    private boolean shouldIgnore(org.junit.runner.Description description) {
        return (HAS_CUCUMBERJVM7_IN_CLASSPATH || HAS_CUCUMBERJVM6_IN_CLASSPATH || HAS_CUCUMBERJVM5_IN_CLASSPATH || HAS_CUCUMBERJVM4_IN_CLASSPATH) && AllureJunit4Utils.isCucumberTest(description);
    }

    private static boolean isClassAvailableOnClasspath(String clazz) {
        try {
            AllureJunit4.class.getClassLoader().loadClass(clazz);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

