/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit4;

import io.qameta.allure.junit4.AllureJunit4Utils;
import io.qameta.allure.model.Label;
import io.qameta.allure.testfilter.FileTestPlanSupplier;
import io.qameta.allure.testfilter.TestPlan;
import io.qameta.allure.testfilter.TestPlanV1_0;
import io.qameta.allure.util.AnnotationUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class AllureJunit4Filter
extends Filter {
    private final TestPlan testPlan;

    public AllureJunit4Filter() {
        this(new FileTestPlanSupplier().supply().orElse(null));
    }

    public AllureJunit4Filter(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public boolean shouldRun(Description description) {
        if (Objects.isNull(this.testPlan)) {
            return true;
        }
        if (description.isSuite()) {
            return true;
        }
        String fullName = AllureJunit4Utils.getFullName(description);
        String allureId = AllureJunit4Filter.findAllureId(description).orElse(null);
        return this.isIncluded(this.testPlan, allureId, fullName);
    }

    public String describe() {
        return "allure testplan filter";
    }

    private boolean isIncluded(TestPlan testPlan, String allureId, String fullName) {
        if (testPlan instanceof TestPlanV1_0) {
            TestPlanV1_0 tp = (TestPlanV1_0)testPlan;
            return Objects.isNull(tp.getTests()) || tp.getTests().stream().filter(Objects::nonNull).anyMatch(tc -> this.match((TestPlanV1_0.TestCase)tc, allureId, fullName));
        }
        return true;
    }

    private boolean match(TestPlanV1_0.TestCase tc, String allureId, String fullName) {
        return Objects.nonNull(tc.getId()) && tc.getId().equals(allureId) || Objects.nonNull(tc.getSelector()) && tc.getSelector().equals(fullName);
    }

    private static Optional<String> findAllureId(Description description) {
        return AnnotationUtils.getLabels((Collection)description.getAnnotations()).stream().filter(l -> "AS_ID".equals(l.getName())).map(Label::getValue).findAny();
    }
}

