/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit4;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Description;
import io.qameta.allure.Epic;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Link;
import io.qameta.allure.Owner;
import io.qameta.allure.Severity;
import io.qameta.allure.Story;
import io.qameta.allure.TmsLink;
import io.qameta.allure.junit4.DisplayName;
import io.qameta.allure.junit4.Tag;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Ignore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@RunListener.ThreadSafe
public class AllureJunit4
extends RunListener {
    private final ThreadLocal<String> testCases = new InheritableThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return UUID.randomUUID().toString();
        }
    };
    private final AllureLifecycle lifecycle;

    public AllureJunit4() {
        this(Allure.getLifecycle());
    }

    public AllureJunit4(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void testRunStarted(org.junit.runner.Description description) {
    }

    public void testRunFinished(Result result) {
    }

    public void testStarted(org.junit.runner.Description description) {
        String uuid = this.testCases.get();
        TestResult result = this.createTestResult(uuid, description);
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().startTestCase(uuid);
    }

    public void testFinished(org.junit.runner.Description description) {
        String uuid = this.testCases.get();
        this.testCases.remove();
        this.getLifecycle().updateTestCase(uuid, testResult -> {
            if (Objects.isNull(testResult.getStatus())) {
                testResult.setStatus(Status.PASSED);
            }
        });
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    public void testFailure(Failure failure) {
        String uuid = this.testCases.get();
        this.getLifecycle().updateTestCase(uuid, testResult -> testResult.setStatus((Status)ResultsUtils.getStatus((Throwable)failure.getException()).orElse(null)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)failure.getException()).orElse(null)));
    }

    public void testAssumptionFailure(Failure failure) {
        String uuid = this.testCases.get();
        this.getLifecycle().updateTestCase(uuid, testResult -> testResult.setStatus(Status.SKIPPED).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)failure.getException()).orElse(null)));
    }

    public void testIgnored(org.junit.runner.Description description) {
        String uuid = this.testCases.get();
        this.testCases.remove();
        TestResult result = this.createTestResult(uuid, description);
        result.setStatus(Status.SKIPPED);
        result.setStatusDetails(this.getIgnoredMessage(description));
        result.setStart(Long.valueOf(System.currentTimeMillis()));
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    private Optional<String> getDisplayName(org.junit.runner.Description result) {
        return Optional.ofNullable(result.getAnnotation(DisplayName.class)).map(DisplayName::value);
    }

    private Optional<String> getDescription(org.junit.runner.Description result) {
        return Optional.ofNullable(result.getAnnotation(Description.class)).map(Description::value);
    }

    private List<io.qameta.allure.model.Link> getLinks(org.junit.runner.Description result) {
        return Stream.of(this.getAnnotationsOnClass(result, Link.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnMethod(result, Link.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnClass(result, Issue.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnMethod(result, Issue.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnClass(result, TmsLink.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnMethod(result, TmsLink.class).stream().map(ResultsUtils::createLink)).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private List<Label> getLabels(org.junit.runner.Description result) {
        return Stream.of(this.getLabels(result, Epic.class, ResultsUtils::createLabel), this.getLabels(result, Feature.class, ResultsUtils::createLabel), this.getLabels(result, Story.class, ResultsUtils::createLabel), this.getLabels(result, Severity.class, ResultsUtils::createLabel), this.getLabels(result, Owner.class, ResultsUtils::createLabel), this.getLabels(result, Tag.class, this::createLabel)).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private <T extends Annotation> Stream<Label> getLabels(org.junit.runner.Description result, Class<T> labelAnnotation, Function<T, Label> extractor) {
        List labels = this.getAnnotationsOnMethod(result, labelAnnotation).stream().map(extractor).collect(Collectors.toList());
        if (labelAnnotation.isAnnotationPresent(Repeatable.class) || labels.isEmpty()) {
            Stream<Label> onClassLabels = this.getAnnotationsOnClass(result, labelAnnotation).stream().map(extractor);
            labels.addAll(onClassLabels.collect(Collectors.toList()));
        }
        return labels.stream();
    }

    private Label createLabel(Tag tag) {
        return new Label().setName("tag").setValue(tag.value());
    }

    private <T extends Annotation> List<T> getAnnotationsOnMethod(org.junit.runner.Description result, Class<T> clazz) {
        Annotation annotation = result.getAnnotation(clazz);
        return Stream.concat(this.extractRepeatable(result, clazz).stream(), Objects.isNull(annotation) ? Stream.empty() : Stream.of(annotation)).collect(Collectors.toList());
    }

    private <T extends Annotation> List<T> extractRepeatable(org.junit.runner.Description result, Class<T> clazz) {
        Repeatable repeatable;
        Class<? extends Annotation> wrapper;
        Annotation annotation;
        if (clazz != null && clazz.isAnnotationPresent(Repeatable.class) && Objects.nonNull(annotation = result.getAnnotation(wrapper = (repeatable = clazz.getAnnotation(Repeatable.class)).value()))) {
            try {
                Method value = annotation.getClass().getMethod("value", new Class[0]);
                Object annotations = value.invoke((Object)annotation, new Object[0]);
                return Arrays.asList((Annotation[])annotations);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return Collections.emptyList();
    }

    private <T extends Annotation> List<T> getAnnotationsOnClass(org.junit.runner.Description result, Class<T> clazz) {
        return Stream.of(result).map(org.junit.runner.Description::getTestClass).filter(Objects::nonNull).map(testClass -> testClass.getAnnotationsByType(clazz)).flatMap(Stream::of).collect(Collectors.toList());
    }

    private String getHistoryId(org.junit.runner.Description description) {
        return ResultsUtils.md5((String)(description.getClassName() + description.getMethodName()));
    }

    private String getPackage(Class<?> testClass) {
        return Optional.ofNullable(testClass).map(Class::getPackage).map(Package::getName).orElse("");
    }

    private StatusDetails getIgnoredMessage(org.junit.runner.Description description) {
        Ignore ignore = (Ignore)description.getAnnotation(Ignore.class);
        String message = Objects.nonNull(ignore) && !ignore.value().isEmpty() ? ignore.value() : "Test ignored (without reason)!";
        return new StatusDetails().setMessage(message);
    }

    private TestResult createTestResult(String uuid, org.junit.runner.Description description) {
        String className = description.getClassName();
        String methodName = description.getMethodName();
        String name = Objects.nonNull(methodName) ? methodName : className;
        String fullName = Objects.nonNull(methodName) ? String.format("%s.%s", className, methodName) : className;
        String suite = Optional.ofNullable(description.getTestClass()).map(it -> it.getAnnotation(DisplayName.class)).map(DisplayName::value).orElse(className);
        TestResult testResult = new TestResult().setUuid(uuid).setHistoryId(this.getHistoryId(description)).setFullName(fullName).setName(name);
        testResult.getLabels().addAll(ResultsUtils.getProvidedLabels());
        testResult.getLabels().addAll(Arrays.asList(ResultsUtils.createPackageLabel((String)this.getPackage(description.getTestClass())), ResultsUtils.createTestClassLabel((String)className), ResultsUtils.createTestMethodLabel((String)name), ResultsUtils.createSuiteLabel((String)suite), ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createFrameworkLabel((String)"junit4"), ResultsUtils.createLanguageLabel((String)"java")));
        testResult.getLabels().addAll(this.getLabels(description));
        testResult.getLinks().addAll(this.getLinks(description));
        this.getDisplayName(description).ifPresent(arg_0 -> ((TestResult)testResult).setName(arg_0));
        this.getDescription(description).ifPresent(arg_0 -> ((TestResult)testResult).setDescription(arg_0));
        return testResult;
    }
}

