/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit5;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.UUID;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;

public class AllureJunit5
implements TestExecutionListener {
    private final ThreadLocal<String> tests = InheritableThreadLocal.withInitial(() -> UUID.randomUUID().toString());
    private final AllureLifecycle lifecycle;

    public AllureJunit5(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureJunit5() {
        this.lifecycle = Allure.getLifecycle();
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            Optional<MethodSource> methodSource = testIdentifier.getSource().filter(MethodSource.class::isInstance).map(MethodSource.class::cast);
            String uuid = this.tests.get();
            TestResult result = new TestResult().withUuid(uuid).withName(testIdentifier.getDisplayName()).withHistoryId(this.getHistoryId(testIdentifier)).withStage(Stage.RUNNING);
            methodSource.ifPresent(source -> {
                result.getLabels().add(new Label().withName("suite").withValue(source.getClassName()));
                result.getLabels().add(new Label().withName("package").withValue(source.getClassName()));
            });
            this.getLifecycle().scheduleTestCase(result);
            this.getLifecycle().startTestCase(uuid);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            String uuid = this.tests.get();
            this.tests.remove();
            this.getLifecycle().updateTestCase(uuid, result -> {
                result.setStage(Stage.FINISHED);
                switch (testExecutionResult.getStatus()) {
                    case FAILED: {
                        testExecutionResult.getThrowable().ifPresent(throwable -> {
                            result.setStatus(this.getStatus((Throwable)throwable));
                            result.setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)throwable).orElse(null));
                        });
                        break;
                    }
                    case SUCCESSFUL: {
                        result.setStatus(Status.PASSED);
                        break;
                    }
                    default: {
                        result.setStatus(Status.SKIPPED);
                        testExecutionResult.getThrowable().ifPresent(throwable -> result.setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)throwable).orElse(null)));
                    }
                }
            });
            this.getLifecycle().stopTestCase(uuid);
            this.getLifecycle().writeTestCase(uuid);
        }
    }

    protected Status getStatus(Throwable throwable) {
        return ResultsUtils.getStatus((Throwable)throwable).orElse(Status.FAILED);
    }

    protected String getHistoryId(TestIdentifier testIdentifier) {
        return this.md5(testIdentifier.getUniqueId());
    }

    private String md5(String source) {
        byte[] bytes = this.getMessageDigest().digest(source.getBytes(StandardCharsets.UTF_8));
        return new BigInteger(1, bytes).toString(16);
    }

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not find md5 hashing algorithm", e);
        }
    }
}

