/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit5;

import io.qameta.allure.Param;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.util.ObjectUtils;
import io.qameta.allure.util.ResultsUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public class AllureJunit5
implements InvocationInterceptor {
    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.sendParameterEvent(invocationContext, extensionContext);
        invocation.proceed();
    }

    private void sendParameterEvent(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        Parameter[] parameters = ((Method)invocationContext.getExecutable()).getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Class<?> parameterType = parameter.getType();
            if (parameterType.getPackage().getName().startsWith("org.junit.jupiter.api")) continue;
            Object value = invocationContext.getArguments().get(i);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("allure.parameter", parameter.getName());
            map.put("value", ObjectUtils.toString(value));
            Stream.of(parameter.getAnnotationsByType(Param.class)).findFirst().ifPresent(param -> {
                Stream.of(param.value(), param.name()).map(String::trim).filter(name -> name.length() > 0).findFirst().ifPresent(name -> map.put("allure.parameter", (String)name));
                map.put("mode", param.mode().name());
                map.put("excluded", Boolean.toString(param.excluded()));
            });
            extensionContext.publishReportEntry(map);
        }
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.processFixture("prepare", invocation, invocationContext, extensionContext);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.processFixture("tear_down", invocation, invocationContext, extensionContext);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.processFixture("prepare", invocation, invocationContext, extensionContext);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.processFixture("tear_down", invocation, invocationContext, extensionContext);
    }

    protected void processFixture(String type, InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        String uuid = UUID.randomUUID().toString();
        try {
            extensionContext.publishReportEntry(this.buildStartEvent(type, uuid, (Method)invocationContext.getExecutable()));
            invocation.proceed();
            extensionContext.publishReportEntry(this.buildStopEvent(type, uuid));
        }
        catch (Throwable throwable) {
            extensionContext.publishReportEntry(this.buildFailureEvent(type, uuid, throwable));
            throw throwable;
        }
    }

    public Map<String, String> buildStartEvent(String type, String uuid, Method method) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("allure.fixture", type);
        map.put("event", "start");
        map.put("uuid", uuid);
        map.put("name", method.getName());
        return map;
    }

    public Map<String, String> buildStopEvent(String type, String uuid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("allure.fixture", type);
        map.put("event", "stop");
        map.put("uuid", uuid);
        return map;
    }

    public Map<String, String> buildFailureEvent(String type, String uuid, Throwable throwable) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("allure.fixture", type);
        map.put("event", "failure");
        map.put("uuid", uuid);
        Optional maybeStatus = ResultsUtils.getStatus((Throwable)throwable);
        maybeStatus.map(Status::value).ifPresent(status -> map.put("status", (String)status));
        Optional maybeDetails = ResultsUtils.getStatusDetails((Throwable)throwable);
        maybeDetails.map(StatusDetails::getMessage).ifPresent(message -> map.put("message", (String)message));
        maybeDetails.map(StatusDetails::getTrace).ifPresent(trace -> map.put("trace", (String)trace));
        return map;
    }
}

