/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit5;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Epic;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Link;
import io.qameta.allure.Owner;
import io.qameta.allure.Severity;
import io.qameta.allure.Story;
import io.qameta.allure.TmsLink;
import io.qameta.allure.model.Label;
import io.qameta.allure.util.ResultsUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AllureJunit5AnnotationProcessor
implements BeforeTestExecutionCallback {
    private static AllureLifecycle lifecycle;

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        AllureJunit5AnnotationProcessor.getLifecycle().getCurrentTestCase().ifPresent(uuid -> AllureJunit5AnnotationProcessor.getLifecycle().updateTestCase(uuid, testResult -> {
            context.getTestClass().ifPresent(testClass -> {
                testResult.getLabels().addAll(this.getLabels((AnnotatedElement)testClass));
                testResult.getLinks().addAll(this.getLinks((AnnotatedElement)testClass));
            });
            context.getTestMethod().ifPresent(testMethod -> {
                testResult.getLabels().addAll(this.getLabels((AnnotatedElement)testMethod));
                testResult.getLinks().addAll(this.getLinks((AnnotatedElement)testMethod));
            });
        }));
    }

    private List<Label> getLabels(AnnotatedElement annotatedElement) {
        return Stream.of(this.getAnnotations(annotatedElement, Epic.class).map(ResultsUtils::createLabel), this.getAnnotations(annotatedElement, Feature.class).map(ResultsUtils::createLabel), this.getAnnotations(annotatedElement, Story.class).map(ResultsUtils::createLabel), this.getAnnotations(annotatedElement, Severity.class).map(ResultsUtils::createLabel), this.getAnnotations(annotatedElement, Owner.class).map(ResultsUtils::createLabel)).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private List<io.qameta.allure.model.Link> getLinks(AnnotatedElement annotatedElement) {
        return Stream.of(this.getAnnotations(annotatedElement, Link.class).map(ResultsUtils::createLink), this.getAnnotations(annotatedElement, Issue.class).map(ResultsUtils::createLink), this.getAnnotations(annotatedElement, TmsLink.class).map(ResultsUtils::createLink)).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private <T extends Annotation> Stream<T> getAnnotations(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        T annotation = annotatedElement.getAnnotation(annotationClass);
        return Stream.concat(this.extractRepeatable(annotatedElement, annotationClass).stream(), Objects.isNull(annotation) ? Stream.empty() : Stream.of(annotation));
    }

    private <T extends Annotation> List<T> extractRepeatable(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        Repeatable repeatable;
        Class<? extends Annotation> wrapper;
        Annotation annotation;
        if (annotationClass.isAnnotationPresent(Repeatable.class) && Objects.nonNull(annotation = annotatedElement.getAnnotation(wrapper = (repeatable = annotationClass.getAnnotation(Repeatable.class)).value()))) {
            try {
                Method value = annotation.getClass().getMethod("value", new Class[0]);
                Object annotations = value.invoke((Object)annotation, new Object[0]);
                return Arrays.asList((Annotation[])annotations);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return Collections.emptyList();
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle = allure;
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }
}

