/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.karate;

import com.intuit.karate.RuntimeHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Attachment;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureKarate
implements RuntimeHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureKarate.class);
    private static final String ALLURE_UUID = "ALLURE_UUID";
    private final AllureLifecycle lifecycle;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, String> stepsAndTcUuids = new HashMap<String, String>();
    private final Map<String, Step> stepAndUuids = new HashMap<String, Step>();
    private final List<String> tcUuids = new ArrayList<String>();

    public AllureKarate() {
        this(Allure.getLifecycle());
    }

    public AllureKarate(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public boolean beforeScenario(ScenarioRuntime sr) {
        Feature feature = sr.featureRuntime.result.getFeature();
        String featureName = feature.getName();
        String featureNameQualified = feature.getPackageQualifiedName();
        Scenario scenario = sr.scenario;
        String scenarioName = scenario.getName();
        String uuid = UUID.randomUUID().toString();
        sr.magicVariables.put(ALLURE_UUID, uuid);
        TestResult result = new TestResult().setUuid(uuid).setFullName(String.format("%s | %s", featureNameQualified, scenarioName)).setName(scenarioName).setDescription(scenario.getDescription()).setTestCaseId(scenario.getUniqueId()).setStage(Stage.RUNNING);
        List labels = sr.tags.getTags();
        List<Label> allLabels = this.getLabels(labels);
        allLabels.add(ResultsUtils.createFeatureLabel((String)featureName));
        result.setLabels(allLabels);
        List<Link> links = this.getLinks(labels);
        if (!links.isEmpty()) {
            result.setLinks(links);
        }
        this.lifecycle.scheduleTestCase(result);
        this.lifecycle.startTestCase(uuid);
        return true;
    }

    public void afterScenario(ScenarioRuntime sr) {
        String uuid = (String)sr.magicVariables.get(ALLURE_UUID);
        if (Objects.isNull(uuid)) {
            return;
        }
        Optional<ScenarioResult> maybeResult = Optional.of(sr).map(s -> s.result);
        Status status = !sr.isFailed() ? Status.PASSED : (Status)maybeResult.map(ScenarioResult::getError).flatMap(ResultsUtils::getStatus).orElse(null);
        StatusDetails statusDetails = maybeResult.map(ScenarioResult::getError).flatMap(ResultsUtils::getStatusDetails).orElse(null);
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        if (sr.result != null && sr.result.getScenario().getExampleIndex() > -1) {
            Map data = sr.result.getScenario().getExampleData();
            Set keys = data.keySet();
            for (String key : keys) {
                list.add(ResultsUtils.createParameter((String)key, sr.result.getScenario().getExampleData().get(key)));
            }
        }
        this.lifecycle.updateTestCase(uuid, tr -> {
            tr.setStage(Stage.FINISHED);
            tr.setStatus(status);
            tr.setStatusDetails(statusDetails);
            tr.setParameters(list);
        });
        this.lifecycle.stopTestCase(uuid);
        this.tcUuids.add(uuid);
    }

    public boolean beforeStep(Step step, ScenarioRuntime sr) {
        String parentUuid = (String)sr.magicVariables.get(ALLURE_UUID);
        if (Objects.isNull(parentUuid)) {
            return true;
        }
        String uuid = parentUuid + "-" + step.getIndex();
        io.qameta.allure.model.StepResult stepResult = new io.qameta.allure.model.StepResult().setName(step.getText());
        this.lifecycle.startStep(parentUuid, uuid, stepResult);
        return true;
    }

    public void afterStep(StepResult result, ScenarioRuntime sr) {
        String parentUuid = (String)sr.magicVariables.get(ALLURE_UUID);
        if (Objects.isNull(parentUuid)) {
            return;
        }
        Step step = result.getStep();
        String uuid = parentUuid + "-" + step.getIndex();
        Result stepResult = result.getResult();
        Status status = !stepResult.isFailed() ? Status.PASSED : (Status)Optional.of(stepResult).map(Result::getError).flatMap(ResultsUtils::getStatus).orElse(null);
        StatusDetails statusDetails = Optional.of(stepResult).map(Result::getError).flatMap(ResultsUtils::getStatusDetails).orElse(null);
        this.lifecycle.updateStep(uuid, s -> {
            s.setStatus(status);
            s.setStatusDetails(statusDetails);
        });
        this.lifecycle.stopStep(uuid);
        if (stepResult.isFailed() && sr.engine.getConfig().getDriverOptions() != null && ((Boolean)sr.engine.getConfig().getDriverOptions().get("screenshotOnFailure")).booleanValue()) {
            this.addToStepsAndTcUuids(uuid, (String)this.lifecycle.getCurrentTestCase().get());
            this.addToStepAndUuids(uuid, step);
        }
        if (Objects.nonNull(result.getEmbeds())) {
            result.getEmbeds().forEach(embed -> {
                try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(embed.getFile().toPath(), new OpenOption[0]));){
                    this.lifecycle.addAttachment(embed.getFile().getName(), embed.getResourceType().contentType, embed.getResourceType().getExtension(), (InputStream)is);
                }
                catch (IOException e) {
                    LOGGER.warn("could not save embedding", (Throwable)e);
                }
            });
        }
    }

    public void afterFeature(FeatureRuntime fr) {
        if (!this.stepsAndTcUuids.isEmpty()) {
            fr.result.getScenarioResults().forEach(sc -> {
                if (Objects.nonNull(sc.getFailedStep())) {
                    this.getKeySetFromStepAndUuids().forEach(uuid -> {
                        if (this.getValueFromStepAndUuids((String)uuid) == sc.getFailedStep().getStep()) {
                            ArrayList attachments = new ArrayList();
                            sc.getFailedStep().getEmbeds().forEach(e -> attachments.add(new Attachment().setSource(e.getFile().getPath()).setType(e.getResourceType().contentType).setName(e.getFile().getName())));
                            this.lifecycle.updateTestCase(this.getValueFromStepsAndTcUuids((String)uuid), result -> result.setAttachments(attachments));
                        }
                    });
                }
            });
        }
        this.tcUuids.forEach(arg_0 -> ((AllureLifecycle)this.lifecycle).writeTestCase(arg_0));
    }

    private List<Label> getLabels(List<String> labels) {
        HashMap<String, String> allureLabels = new HashMap<String, String>();
        ArrayList<Label> allLabels = new ArrayList<Label>();
        for (String tag : labels.stream().filter(l -> l.contains("allure")).collect(Collectors.toList())) {
            String tagName = tag.substring(0, tag.indexOf(58));
            String tagValue = tag.substring(tag.indexOf(58) + 1);
            if (tagName.contains("allure.label")) {
                allureLabels.put(tagName.substring("allure.label.".length()), tagValue);
            }
            if (tagName.contains("allure.id")) {
                allureLabels.put("AS_ID", tagValue);
            }
            if (!tagName.contains("allure.severity")) continue;
            allureLabels.put("severity", tagValue);
        }
        allureLabels.keySet().forEach(key -> allLabels.add(ResultsUtils.createLabel((String)key, (String)((String)allureLabels.get(key)))));
        return allLabels;
    }

    private List<Link> getLinks(List<String> labels) {
        ArrayList<Link> allureLinks = new ArrayList<Link>();
        for (String tag : labels.stream().filter(l -> l.contains("allure.link")).collect(Collectors.toList())) {
            String tagName = tag.substring(0, tag.indexOf(58));
            String tagValue = tag.substring(tag.indexOf(58) + 1);
            switch (tagName.substring("allure.link".length())) {
                case "": {
                    allureLinks.add(ResultsUtils.createLink((String)tagValue, (String)"", (String)"", (String)"custom"));
                    break;
                }
                case ".tms": {
                    allureLinks.add(ResultsUtils.createLink((String)tagValue, (String)"", (String)"", (String)"tms"));
                    break;
                }
                case ".issue": {
                    allureLinks.add(ResultsUtils.createLink((String)tagValue, (String)"", (String)"", (String)"issue"));
                    break;
                }
            }
        }
        return allureLinks;
    }

    private void addToStepsAndTcUuids(String stepUuid, String tcUuid) {
        this.lock.writeLock().lock();
        try {
            this.stepsAndTcUuids.put(stepUuid, tcUuid);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void addToStepAndUuids(String stepUuid, Step step) {
        this.lock.writeLock().lock();
        try {
            this.stepAndUuids.put(stepUuid, step);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private String getValueFromStepsAndTcUuids(String stepUuid) {
        this.lock.readLock().lock();
        try {
            String string = this.stepsAndTcUuids.get(stepUuid);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Step getValueFromStepAndUuids(String stepUuid) {
        this.lock.readLock().lock();
        try {
            Step step = this.stepAndUuids.get(stepUuid);
            return step;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Set<String> getKeySetFromStepAndUuids() {
        this.lock.readLock().lock();
        try {
            Set<String> set = this.stepAndUuids.keySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

