/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.karate;

import com.intuit.karate.RuntimeHook;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureKarate
implements RuntimeHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureKarate.class);
    private static final String ALLURE_UUID = "ALLURE_UUID";
    private final AllureLifecycle lifecycle;
    private final List<String> tcUuids = new ArrayList<String>();

    public AllureKarate() {
        this(Allure.getLifecycle());
    }

    public AllureKarate(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public boolean beforeScenario(ScenarioRuntime sr) {
        Feature feature = sr.featureRuntime.result.getFeature();
        String featureName = feature.getName();
        String featureNameQualified = feature.getResource().getRelativePath();
        Scenario scenario = sr.scenario;
        String uuid = UUID.randomUUID().toString();
        sr.magicVariables.put(ALLURE_UUID, uuid);
        String nameOrLine = AllureKarate.getName(scenario, String.valueOf(scenario.getLine()));
        String testCaseId = ResultsUtils.md5((String)String.format("%s:%s", featureNameQualified, nameOrLine));
        String fullName = String.format("%s:%d", featureNameQualified, scenario.getLine());
        TestResult result = new TestResult().setUuid(uuid).setFullName(fullName).setName(AllureKarate.getName(scenario, fullName)).setDescription(scenario.getDescription()).setTestCaseId(testCaseId).setHistoryId(ResultsUtils.md5((String)scenario.getUniqueId())).setStage(Stage.RUNNING);
        List labels = sr.tags.getTags();
        List<Label> allLabels = this.getLabels(labels);
        allLabels.add(ResultsUtils.createFeatureLabel((String)featureName));
        result.setLabels(allLabels);
        List<Link> links = this.getLinks(labels);
        if (!links.isEmpty()) {
            result.setLinks(links);
        }
        this.lifecycle.scheduleTestCase(result);
        this.lifecycle.startTestCase(uuid);
        return true;
    }

    private static String getName(Scenario scenario, String defaultValue) {
        if (Objects.isNull(scenario.getName())) {
            return defaultValue;
        }
        boolean blank = scenario.getName().chars().allMatch(Character::isWhitespace);
        return blank ? defaultValue : scenario.getName().trim();
    }

    public void afterScenario(ScenarioRuntime sr) {
        String uuid = (String)sr.magicVariables.get(ALLURE_UUID);
        if (Objects.isNull(uuid)) {
            return;
        }
        Optional<ScenarioResult> maybeResult = Optional.of(sr).map(s -> s.result);
        Status status = !sr.isFailed() ? Status.PASSED : (Status)maybeResult.map(ScenarioResult::getError).flatMap(ResultsUtils::getStatus).orElse(null);
        StatusDetails statusDetails = maybeResult.map(ScenarioResult::getError).flatMap(ResultsUtils::getStatusDetails).orElse(null);
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        if (sr.result != null && sr.result.getScenario().getExampleIndex() > -1) {
            Map data = sr.result.getScenario().getExampleData();
            Set keys = data.keySet();
            for (String key : keys) {
                list.add(ResultsUtils.createParameter((String)key, sr.result.getScenario().getExampleData().get(key)));
            }
        }
        this.lifecycle.updateTestCase(uuid, tr -> {
            tr.setStage(Stage.FINISHED);
            tr.setStatus(status);
            tr.setStatusDetails(statusDetails);
            tr.setParameters(list);
        });
        this.lifecycle.stopTestCase(uuid);
        this.tcUuids.add(uuid);
    }

    public boolean beforeStep(Step step, ScenarioRuntime sr) {
        String parentUuid = (String)sr.magicVariables.get(ALLURE_UUID);
        if (Objects.isNull(parentUuid)) {
            return true;
        }
        String uuid = parentUuid + "-" + step.getIndex();
        io.qameta.allure.model.StepResult stepResult = new io.qameta.allure.model.StepResult().setName(step.getText());
        this.lifecycle.startStep(parentUuid, uuid, stepResult);
        return true;
    }

    public void afterStep(StepResult result, ScenarioRuntime sr) {
        String parentUuid = (String)sr.magicVariables.get(ALLURE_UUID);
        if (Objects.isNull(parentUuid)) {
            return;
        }
        Step step = result.getStep();
        String uuid = parentUuid + "-" + step.getIndex();
        Result stepResult = result.getResult();
        Status status = !stepResult.isFailed() ? Status.PASSED : (Status)Optional.of(stepResult).map(Result::getError).flatMap(ResultsUtils::getStatus).orElse(null);
        StatusDetails statusDetails = Optional.of(stepResult).map(Result::getError).flatMap(ResultsUtils::getStatusDetails).orElse(null);
        this.lifecycle.updateStep(uuid, s -> {
            s.setStatus(status);
            s.setStatusDetails(statusDetails);
        });
        this.lifecycle.stopStep(uuid);
        if (Objects.nonNull(result.getEmbeds())) {
            result.getEmbeds().forEach(embed -> {
                try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(embed.getFile().toPath(), new OpenOption[0]));){
                    this.lifecycle.addAttachment(embed.getFile().getName(), embed.getResourceType().contentType, embed.getResourceType().getExtension(), (InputStream)is);
                }
                catch (IOException e) {
                    LOGGER.warn("could not save embedding", (Throwable)e);
                }
            });
        }
    }

    public void afterFeature(FeatureRuntime fr) {
        this.tcUuids.forEach(arg_0 -> ((AllureLifecycle)this.lifecycle).writeTestCase(arg_0));
    }

    private List<Label> getLabels(List<String> labels) {
        HashMap<String, String> allureLabels = new HashMap<String, String>();
        ArrayList<Label> allLabels = new ArrayList<Label>();
        for (String tag : labels.stream().filter(l -> l.contains("allure")).collect(Collectors.toList())) {
            String tagName = tag.substring(0, tag.indexOf(58));
            String tagValue = tag.substring(tag.indexOf(58) + 1);
            if (tagName.contains("allure.label")) {
                allureLabels.put(tagName.substring("allure.label.".length()), tagValue);
            }
            if (tagName.contains("allure.id")) {
                allureLabels.put("AS_ID", tagValue);
            }
            if (!tagName.contains("allure.severity")) continue;
            allureLabels.put("severity", tagValue);
        }
        allureLabels.keySet().forEach(key -> allLabels.add(ResultsUtils.createLabel((String)key, (String)((String)allureLabels.get(key)))));
        return allLabels;
    }

    private List<Link> getLinks(List<String> labels) {
        ArrayList<Link> allureLinks = new ArrayList<Link>();
        for (String tag : labels.stream().filter(l -> l.contains("allure.link")).collect(Collectors.toList())) {
            String tagName = tag.substring(0, tag.indexOf(58));
            String tagValue = tag.substring(tag.indexOf(58) + 1);
            switch (tagName.substring("allure.link".length())) {
                case "": {
                    allureLinks.add(ResultsUtils.createLink((String)tagValue, (String)"", (String)"", (String)"custom"));
                    break;
                }
                case ".tms": {
                    allureLinks.add(ResultsUtils.createLink((String)tagValue, (String)"", (String)"", (String)"tms"));
                    break;
                }
                case ".issue": {
                    allureLinks.add(ResultsUtils.createLink((String)tagValue, (String)"", (String)"", (String)"issue"));
                    break;
                }
            }
        }
        return allureLinks;
    }
}

