/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.kotlin;

import io.qameta.allure.kotlin.AllureResultsWriter;
import io.qameta.allure.kotlin.FileSystemResultsWriter;
import io.qameta.allure.kotlin.internal.AllureStorage;
import io.qameta.allure.kotlin.internal.AllureThreadContext;
import io.qameta.allure.kotlin.listener.ContainerLifecycleListener;
import io.qameta.allure.kotlin.listener.FixtureLifecycleListener;
import io.qameta.allure.kotlin.listener.LifecycleNotifier;
import io.qameta.allure.kotlin.listener.StepLifecycleListener;
import io.qameta.allure.kotlin.listener.TestLifecycleListener;
import io.qameta.allure.kotlin.model.Attachment;
import io.qameta.allure.kotlin.model.FixtureResult;
import io.qameta.allure.kotlin.model.Stage;
import io.qameta.allure.kotlin.model.StepResult;
import io.qameta.allure.kotlin.model.TestResult;
import io.qameta.allure.kotlin.model.TestResultContainer;
import io.qameta.allure.kotlin.model.WithAttachments;
import io.qameta.allure.kotlin.model.WithSteps;
import io.qameta.allure.kotlin.util.LogUtils;
import io.qameta.allure.kotlin.util.PropertiesUtils;
import io.qameta.allure.kotlin.util.ServiceLoaderUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 92\u00020\u0001:\u00019B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eJ*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020 H\u0002J\u001e\u0010!\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020 J\u0016\u0010\"\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020#J\u001e\u0010\"\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020#J\u001e\u0010%\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020 J\u000e\u0010&\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)J\u0016\u0010'\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0006\u0010+\u001a\u00020\fJ\u000e\u0010+\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010,\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010-\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000eJ\u001a\u0010.\u001a\u00020\f2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\f00J\"\u0010.\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\f00J\u001a\u00101\u001a\u00020\f2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\f00J\"\u00101\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\f00J\u001a\u00103\u001a\u00020\f2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\f00J\"\u00103\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\f00J\"\u00104\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\f00J\u0016\u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u00107\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u00108\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lio/qameta/allure/kotlin/AllureLifecycle;", "", "writer", "Lio/qameta/allure/kotlin/AllureResultsWriter;", "notifier", "Lio/qameta/allure/kotlin/listener/LifecycleNotifier;", "(Lio/qameta/allure/kotlin/AllureResultsWriter;Lio/qameta/allure/kotlin/listener/LifecycleNotifier;)V", "storage", "Lio/qameta/allure/kotlin/internal/AllureStorage;", "threadContext", "Lio/qameta/allure/kotlin/internal/AllureThreadContext;", "addAttachment", "", "name", "", "stream", "Ljava/io/InputStream;", "type", "fileExtension", "body", "", "getCurrentTestCase", "getCurrentTestCaseOrStep", "prepareAttachment", "scheduleTestCase", "result", "Lio/qameta/allure/kotlin/model/TestResult;", "containerUuid", "setCurrentTestCase", "", "uuid", "startFixture", "Lio/qameta/allure/kotlin/model/FixtureResult;", "startPrepareFixture", "startStep", "Lio/qameta/allure/kotlin/model/StepResult;", "parentUuid", "startTearDownFixture", "startTestCase", "startTestContainer", "container", "Lio/qameta/allure/kotlin/model/TestResultContainer;", "stopFixture", "stopStep", "stopTestCase", "stopTestContainer", "updateFixture", "updateBlock", "Lkotlin/Function1;", "updateStep", "update", "updateTestCase", "updateTestContainer", "writeAttachment", "attachmentSource", "writeTestCase", "writeTestContainer", "Companion", "allure-kotlin-commons"})
public class AllureLifecycle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AllureResultsWriter writer;
    @NotNull
    private final LifecycleNotifier notifier;
    @NotNull
    private final AllureStorage storage;
    @NotNull
    private final AllureThreadContext threadContext;
    @NotNull
    private static final Logger LOGGER;

    @JvmOverloads
    public AllureLifecycle(@NotNull AllureResultsWriter writer, @NotNull LifecycleNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        this.writer = writer;
        this.notifier = notifier;
        this.storage = new AllureStorage();
        this.threadContext = new AllureThreadContext();
    }

    public /* synthetic */ AllureLifecycle(AllureResultsWriter allureResultsWriter, LifecycleNotifier lifecycleNotifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            allureResultsWriter = AllureLifecycle.Companion.getDefaultWriter();
        }
        if ((n & 2) != 0) {
            lifecycleNotifier = AllureLifecycle.Companion.getDefaultNotifier();
        }
        this(allureResultsWriter, lifecycleNotifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startTestContainer(@NotNull String containerUuid, @NotNull TestResultContainer container) {
        Intrinsics.checkNotNullParameter((Object)containerUuid, (String)"containerUuid");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        TestResultContainer testResultContainer = this.storage.getContainer(containerUuid);
        if (testResultContainer != null) {
            TestResultContainer testResultContainer2 = testResultContainer;
            boolean bl = false;
            boolean bl2 = false;
            TestResultContainer it = testResultContainer2;
            boolean bl3 = false;
            AllureStorage allureStorage = this.storage;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (allureStorage) {
                boolean bl6 = false;
                bl5 = it.getChildren().add(container.getUuid());
            }
        }
        this.startTestContainer(container);
    }

    public final void startTestContainer(@NotNull TestResultContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.notifier.beforeContainerStart(container);
        container.setStart(Long.valueOf(System.currentTimeMillis()));
        this.storage.put(container.getUuid(), container);
        this.notifier.afterContainerStart(container);
    }

    public final void updateTestContainer(@NotNull String uuid, @NotNull Function1<? super TestResultContainer, Unit> updateBlock) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(updateBlock, (String)"updateBlock");
        TestResultContainer testResultContainer = this.storage.getContainer(uuid);
        if (testResultContainer == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not update test container: container with uuid " + uuid + " not found", null, 2, null);
            return;
        }
        TestResultContainer container = testResultContainer;
        this.notifier.beforeContainerUpdate(container);
        updateBlock.invoke((Object)container);
        this.notifier.afterContainerUpdate(container);
    }

    public final void stopTestContainer(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        TestResultContainer testResultContainer = this.storage.getContainer(uuid);
        if (testResultContainer == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not stop test container: container with uuid " + uuid + " not found", null, 2, null);
            return;
        }
        TestResultContainer container = testResultContainer;
        this.notifier.beforeContainerStop(container);
        container.setStop(Long.valueOf(System.currentTimeMillis()));
        this.notifier.afterContainerUpdate(container);
    }

    public final void writeTestContainer(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        TestResultContainer testResultContainer = this.storage.getContainer(uuid);
        if (testResultContainer == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not write test container: container with uuid " + uuid + " not found", null, 2, null);
            return;
        }
        TestResultContainer container = testResultContainer;
        this.notifier.beforeContainerWrite(container);
        this.writer.write(container);
        this.storage.remove(uuid);
        this.notifier.afterContainerWrite(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startPrepareFixture(@NotNull String containerUuid, @NotNull String uuid, @NotNull FixtureResult result) {
        Intrinsics.checkNotNullParameter((Object)containerUuid, (String)"containerUuid");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        TestResultContainer testResultContainer = this.storage.getContainer(containerUuid);
        if (testResultContainer != null) {
            TestResultContainer testResultContainer2 = testResultContainer;
            boolean bl = false;
            boolean bl2 = false;
            TestResultContainer it = testResultContainer2;
            boolean bl3 = false;
            AllureStorage allureStorage = this.storage;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (allureStorage) {
                boolean bl6 = false;
                bl5 = it.getBefores().add(result);
            }
        }
        this.notifier.beforeFixtureStart(result);
        this.startFixture(uuid, result);
        this.notifier.afterFixtureStart(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startTearDownFixture(@NotNull String containerUuid, @NotNull String uuid, @NotNull FixtureResult result) {
        Intrinsics.checkNotNullParameter((Object)containerUuid, (String)"containerUuid");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        TestResultContainer testResultContainer = this.storage.getContainer(containerUuid);
        if (testResultContainer != null) {
            TestResultContainer testResultContainer2 = testResultContainer;
            boolean bl = false;
            boolean bl2 = false;
            TestResultContainer it = testResultContainer2;
            boolean bl3 = false;
            AllureStorage allureStorage = this.storage;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (allureStorage) {
                boolean bl6 = false;
                bl5 = it.getAfters().add(result);
            }
        }
        this.notifier.beforeFixtureStart(result);
        this.startFixture(uuid, result);
        this.notifier.afterFixtureStart(result);
    }

    private final void startFixture(String uuid, FixtureResult result) {
        this.storage.put(uuid, result);
        result.setStage(Stage.RUNNING);
        result.setStart(Long.valueOf(System.currentTimeMillis()));
        this.threadContext.clear();
        this.threadContext.start(uuid);
    }

    public final void updateFixture(@NotNull Function1<? super FixtureResult, Unit> updateBlock) {
        Intrinsics.checkNotNullParameter(updateBlock, (String)"updateBlock");
        String string = this.threadContext.getRoot();
        if (string == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not update test fixture: no test fixture running", null, 2, null);
            return;
        }
        String uuid = string;
        this.updateFixture(uuid, updateBlock);
    }

    public final void updateFixture(@NotNull String uuid, @NotNull Function1<? super FixtureResult, Unit> updateBlock) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(updateBlock, (String)"updateBlock");
        FixtureResult fixtureResult = this.storage.getFixture(uuid);
        if (fixtureResult == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not update test fixture: test fixture with uuid " + uuid + " not found", null, 2, null);
            return;
        }
        FixtureResult fixture = fixtureResult;
        this.notifier.beforeFixtureUpdate(fixture);
        updateBlock.invoke((Object)fixture);
        this.notifier.afterFixtureUpdate(fixture);
    }

    public final void stopFixture(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        FixtureResult fixtureResult = this.storage.getFixture(uuid);
        if (fixtureResult == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not update test fixture: test fixture with uuid " + uuid + " not found", null, 2, null);
            return;
        }
        FixtureResult fixture = fixtureResult;
        this.notifier.beforeFixtureStop(fixture);
        fixture.setStage(Stage.FINISHED);
        fixture.setStop(Long.valueOf(System.currentTimeMillis()));
        this.storage.remove(uuid);
        this.threadContext.clear();
        this.notifier.afterFixtureStop(fixture);
    }

    @Nullable
    public final String getCurrentTestCase() {
        return this.threadContext.getRoot();
    }

    @Nullable
    public final String getCurrentTestCaseOrStep() {
        return this.threadContext.getCurrent();
    }

    public final boolean setCurrentTestCase(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        TestResult testResult = this.storage.getTestResult(uuid);
        if (testResult == null) {
            return false;
        }
        TestResult found = testResult;
        this.threadContext.clear();
        this.threadContext.start(uuid);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scheduleTestCase(@NotNull String containerUuid, @NotNull TestResult result) {
        Intrinsics.checkNotNullParameter((Object)containerUuid, (String)"containerUuid");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        TestResultContainer testResultContainer = this.storage.getContainer(containerUuid);
        if (testResultContainer != null) {
            TestResultContainer testResultContainer2 = testResultContainer;
            boolean bl = false;
            boolean bl2 = false;
            TestResultContainer it = testResultContainer2;
            boolean bl3 = false;
            AllureStorage allureStorage = this.storage;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (allureStorage) {
                boolean bl6 = false;
                bl5 = it.getChildren().add(result.getUuid());
            }
        }
        this.scheduleTestCase(result);
    }

    public final void scheduleTestCase(@NotNull TestResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.notifier.beforeTestSchedule(result);
        result.setStage(Stage.SCHEDULED);
        this.storage.put(result.getUuid(), result);
        this.notifier.afterTestSchedule(result);
    }

    public final void startTestCase(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.threadContext.clear();
        TestResult testResult = this.storage.getTestResult(uuid);
        if (testResult == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not start test case: test case with uuid " + uuid + " is not scheduled", null, 2, null);
            return;
        }
        TestResult testResult2 = testResult;
        this.notifier.beforeTestStart(testResult2);
        boolean bl = false;
        boolean bl4 = false;
        TestResult $this$startTestCase_u24lambda_u2d15 = testResult2;
        boolean bl5 = false;
        $this$startTestCase_u24lambda_u2d15.setStage(Stage.RUNNING);
        $this$startTestCase_u24lambda_u2d15.setStart(Long.valueOf(System.currentTimeMillis()));
        this.threadContext.start(uuid);
        this.notifier.afterTestStart(testResult2);
    }

    public final void updateTestCase(@NotNull Function1<? super TestResult, Unit> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
        String string = this.threadContext.getRoot();
        if (string == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not update test case: no test case running", null, 2, null);
            return;
        }
        String uuid = string;
        this.updateTestCase(uuid, update);
    }

    public final void updateTestCase(@NotNull String uuid, @NotNull Function1<? super TestResult, Unit> update) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(update, (String)"update");
        TestResult testResult = this.storage.getTestResult(uuid);
        if (testResult == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not update test case: test case with uuid " + uuid + " not found", null, 2, null);
            return;
        }
        TestResult testResult2 = testResult;
        this.notifier.beforeTestUpdate(testResult2);
        update.invoke((Object)testResult2);
        this.notifier.afterTestUpdate(testResult2);
    }

    public final void stopTestCase(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        TestResult testResult = this.storage.getTestResult(uuid);
        if (testResult == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not stop test case: test case with uuid " + uuid + " not found", null, 2, null);
            return;
        }
        TestResult testResult2 = testResult;
        this.notifier.beforeTestStop(testResult2);
        boolean bl = false;
        boolean bl4 = false;
        TestResult $this$stopTestCase_u24lambda_u2d19 = testResult2;
        boolean bl5 = false;
        $this$stopTestCase_u24lambda_u2d19.setStage(Stage.FINISHED);
        $this$stopTestCase_u24lambda_u2d19.setStop(Long.valueOf(System.currentTimeMillis()));
        this.threadContext.clear();
        this.notifier.afterTestStop(testResult2);
    }

    public final void writeTestCase(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        TestResult testResult = this.storage.getTestResult(uuid);
        if (testResult == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not write test case: test case with uuid " + uuid + " not found", null, 2, null);
            return;
        }
        TestResult testResult2 = testResult;
        this.notifier.beforeTestWrite(testResult2);
        this.writer.write(testResult2);
        this.storage.remove(uuid);
        this.notifier.afterTestWrite(testResult2);
    }

    public final void startStep(@NotNull String uuid, @NotNull StepResult result) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String string = this.threadContext.getCurrent();
        if (string == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not start step: no test case running", null, 2, null);
            return;
        }
        String parentUuid = string;
        this.startStep(parentUuid, uuid, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startStep(@NotNull String parentUuid, @NotNull String uuid, @NotNull StepResult result) {
        Intrinsics.checkNotNullParameter((Object)parentUuid, (String)"parentUuid");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.notifier.beforeStepStart(result);
        boolean bl = false;
        boolean bl2 = false;
        StepResult $this$startStep_u24lambda_u2d22 = result;
        boolean bl3 = false;
        $this$startStep_u24lambda_u2d22.setStage(Stage.RUNNING);
        $this$startStep_u24lambda_u2d22.setStart(Long.valueOf(System.currentTimeMillis()));
        this.threadContext.start(uuid);
        this.storage.put(uuid, result);
        WithSteps withSteps = (WithSteps)this.storage.get(parentUuid);
        if (withSteps != null) {
            WithSteps withSteps2 = withSteps;
            boolean bl4 = false;
            boolean bl5 = false;
            WithSteps parentStep = withSteps2;
            boolean bl6 = false;
            AllureStorage allureStorage = this.storage;
            boolean bl7 = false;
            boolean bl8 = false;
            synchronized (allureStorage) {
                boolean bl9 = false;
                bl8 = parentStep.getSteps().add(result);
            }
        }
        this.notifier.afterStepStart(result);
    }

    public final void updateStep(@NotNull Function1<? super StepResult, Unit> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
        String string = this.threadContext.getCurrent();
        if (string == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not update step: no step running", null, 2, null);
            return;
        }
        String uuid = string;
        this.updateStep(uuid, update);
    }

    public final void updateStep(@NotNull String uuid, @NotNull Function1<? super StepResult, Unit> update) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(update, (String)"update");
        StepResult stepResult = this.storage.getStep(uuid);
        if (stepResult == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not update step: step with uuid " + uuid + " not found", null, 2, null);
            return;
        }
        StepResult step2 = stepResult;
        this.notifier.beforeStepUpdate(step2);
        update.invoke((Object)step2);
        this.notifier.afterStepUpdate(step2);
    }

    public final void stopStep() {
        String string;
        String root = this.threadContext.getRoot();
        String string2 = this.threadContext.getCurrent();
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        String string3 = string = !Intrinsics.areEqual((Object)it, (Object)root) ? string2 : null;
        if (string == null) {
            string2 = Unit.INSTANCE;
            bl = false;
            bl2 = false;
            it = string2;
            boolean bl4 = false;
            LogUtils.error$default(LOGGER, "Could not stop step: no step running", null, 2, null);
            return;
        }
        String uuid = string;
        this.stopStep(uuid);
    }

    public final void stopStep(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        StepResult stepResult = this.storage.getStep(uuid);
        if (stepResult == null) {
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            LogUtils.error$default(LOGGER, "Could not stop step: step with uuid " + uuid + " not found", null, 2, null);
            return;
        }
        StepResult step2 = stepResult;
        this.notifier.beforeStepStop(step2);
        boolean bl = false;
        boolean bl4 = false;
        StepResult $this$stopStep_u24lambda_u2d30 = step2;
        boolean bl5 = false;
        $this$stopStep_u24lambda_u2d30.setStage(Stage.FINISHED);
        $this$stopStep_u24lambda_u2d30.setStop(Long.valueOf(System.currentTimeMillis()));
        this.storage.remove(uuid);
        this.threadContext.stop();
        this.notifier.afterStepStop(step2);
    }

    public final void addAttachment(@NotNull String name2, @NotNull byte[] body, @Nullable String type, @Nullable String fileExtension) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.addAttachment(name2, new ByteArrayInputStream(body), type, fileExtension);
    }

    public final void addAttachment(@NotNull String name2, @NotNull InputStream stream, @Nullable String type, @Nullable String fileExtension) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.writeAttachment(this.prepareAttachment(name2, type, fileExtension), stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String prepareAttachment(@NotNull String name2, @Nullable String type, @Nullable String fileExtension) {
        boolean bl;
        String string;
        String string2;
        String string3;
        String it;
        boolean bl2;
        boolean bl3;
        String string4;
        String string5;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string6 = fileExtension;
        if (string6 == null) {
            string5 = null;
        } else {
            string4 = string6;
            bl3 = false;
            bl2 = false;
            it = string4;
            boolean bl4 = false;
            CharSequence charSequence = it;
            boolean bl5 = false;
            string5 = string3 = charSequence.length() > 0 ? string4 : null;
        }
        if (string3 == null) {
            string2 = "";
        } else {
            string4 = string3;
            bl3 = false;
            bl2 = false;
            it = string4;
            boolean bl6 = false;
            string6 = it.charAt(0) == '.' ? it : Intrinsics.stringPlus((String)".", (Object)it);
            string2 = string6 == null ? "" : string6;
        }
        String extension = string2;
        String source = UUID.randomUUID().toString() + "-attachment" + extension;
        string4 = this.threadContext.getCurrent();
        if (string4 == null) {
            String string7 = source;
            bl2 = false;
            boolean bl7 = false;
            String it2 = string7;
            boolean bl8 = false;
            LogUtils.error$default(LOGGER, "Could not add attachment: no test is running", null, 2, null);
            return string7;
        }
        String uuid = string4;
        String string8 = name2;
        bl2 = false;
        boolean bl9 = false;
        String it2 = string8;
        String string9 = source;
        boolean bl102 = false;
        CharSequence charSequence = it2;
        boolean bl11 = false;
        boolean bl12 = charSequence.length() > 0;
        String string10 = string9;
        String string11 = bl12 ? string8 : null;
        string8 = type;
        if (string8 == null) {
            string = null;
        } else {
            void it3;
            String string12 = string8;
            bl9 = false;
            boolean bl13 = false;
            String bl102 = string12;
            String string13 = string11;
            string9 = string10;
            boolean bl14 = false;
            CharSequence charSequence2 = (CharSequence)it3;
            bl = false;
            boolean bl15 = charSequence2.length() > 0;
            string10 = string9;
            string11 = string13;
            string = bl15 ? string12 : null;
        }
        String string14 = string;
        String string15 = string11;
        String string16 = string10;
        Attachment attachment = new Attachment(string16, string15, string14);
        string8 = (WithAttachments)this.storage.get(uuid);
        if (string8 != null) {
            String string17 = string8;
            bl9 = false;
            boolean bl16 = false;
            String it4 = string17;
            boolean bl17 = false;
            AllureStorage allureStorage = this.storage;
            bl = false;
            boolean bl18 = false;
            synchronized (allureStorage) {
                boolean bl19 = false;
                bl18 = it4.getAttachments().add(attachment);
            }
        }
        return attachment.getSource();
    }

    public final void writeAttachment(@NotNull String attachmentSource, @NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)attachmentSource, (String)"attachmentSource");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.writer.write(attachmentSource, stream);
    }

    @JvmOverloads
    public AllureLifecycle(@NotNull AllureResultsWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this(writer, null, 2, null);
    }

    @JvmOverloads
    public AllureLifecycle() {
        this(null, null, 3, null);
    }

    static {
        boolean $i$f$loggerFor = false;
        Logger logger = Logger.getLogger(AllureLifecycle.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(T::class.java.name)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/qameta/allure/kotlin/AllureLifecycle$Companion;", "", "()V", "LOGGER", "Ljava/util/logging/Logger;", "getDefaultNotifier", "Lio/qameta/allure/kotlin/listener/LifecycleNotifier;", "getDefaultWriter", "Lio/qameta/allure/kotlin/FileSystemResultsWriter;", "allure-kotlin-commons"})
    public static final class Companion {
        private Companion() {
        }

        private final FileSystemResultsWriter getDefaultWriter() {
            String path = PropertiesUtils.INSTANCE.getResultsDirectoryPath();
            return new FileSystemResultsWriter((Function0<? extends File>)((Function0)new Function0<File>(path){
                final /* synthetic */ String $path;
                {
                    this.$path = $path;
                    super(0);
                }

                @NotNull
                public final File invoke() {
                    return new File(this.$path);
                }
            }));
        }

        private final LifecycleNotifier getDefaultNotifier() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"classLoader");
            return new LifecycleNotifier(ServiceLoaderUtils.load(ContainerLifecycleListener.class, classLoader), ServiceLoaderUtils.load(TestLifecycleListener.class, classLoader), ServiceLoaderUtils.load(FixtureLifecycleListener.class, classLoader), ServiceLoaderUtils.load(StepLifecycleListener.class, classLoader));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

