/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.kotlin;

import io.qameta.allure.kotlin.AllureResultsWriteException;
import io.qameta.allure.kotlin.AllureResultsWriter;
import io.qameta.allure.kotlin.FileSystemResultsWriter;
import io.qameta.allure.kotlin.model.TestResult;
import io.qameta.allure.kotlin.model.TestResultContainer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0014\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/qameta/allure/kotlin/FileSystemResultsWriter;", "Lio/qameta/allure/kotlin/AllureResultsWriter;", "outputDirectoryProvider", "Lkotlin/Function0;", "Ljava/io/File;", "(Lkotlin/jvm/functions/Function0;)V", "mapper", "Lkotlinx/serialization/json/Json;", "outputDirectory", "getOutputDirectory", "()Ljava/io/File;", "outputDirectory$delegate", "Lkotlin/Lazy;", "createDirectories", "", "directory", "generateTestResultContainerName", "", "uuid", "write", "testResult", "Lio/qameta/allure/kotlin/model/TestResult;", "testResultContainer", "Lio/qameta/allure/kotlin/model/TestResultContainer;", "source", "attachment", "Ljava/io/InputStream;", "Companion", "allure-kotlin-commons"})
public final class FileSystemResultsWriter
implements AllureResultsWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<File> outputDirectoryProvider;
    @NotNull
    private final Lazy outputDirectory$delegate;
    @NotNull
    private final Json mapper;

    public FileSystemResultsWriter(@NotNull Function0<? extends File> outputDirectoryProvider) {
        Intrinsics.checkNotNullParameter(outputDirectoryProvider, (String)"outputDirectoryProvider");
        this.outputDirectoryProvider = outputDirectoryProvider;
        this.outputDirectory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ FileSystemResultsWriter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return (File)FileSystemResultsWriter.access$getOutputDirectoryProvider$p(this.this$0).invoke();
            }
        }));
        this.mapper = JsonKt.Json$default(null, (Function1)mapper.1.INSTANCE, (int)1, null);
    }

    private final File getOutputDirectory() {
        Lazy lazy = this.outputDirectory$delegate;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    @Override
    public void write(@NotNull TestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        String testResultName = Companion.generateTestResultName(testResult.getUuid());
        this.createDirectories(this.getOutputDirectory());
        File file = FilesKt.resolve((File)this.getOutputDirectory(), (String)testResultName);
        try {
            String json = this.mapper.encodeToString((SerializationStrategy)TestResult.Companion.serializer(), (Object)testResult);
            FilesKt.writeText$default((File)file, (String)json, null, (int)2, null);
        }
        catch (IOException e) {
            throw new AllureResultsWriteException("Could not write Allure test result", e);
        }
    }

    @Override
    public void write(@NotNull TestResultContainer testResultContainer) {
        Intrinsics.checkNotNullParameter((Object)testResultContainer, (String)"testResultContainer");
        String testResultContainerName = this.generateTestResultContainerName(testResultContainer.getUuid());
        this.createDirectories(this.getOutputDirectory());
        File filePath = FilesKt.resolve((File)this.getOutputDirectory(), (String)testResultContainerName);
        try {
            String json = this.mapper.encodeToString((SerializationStrategy)TestResultContainer.Companion.serializer(), (Object)testResultContainer);
            FilesKt.writeText$default((File)filePath, (String)json, null, (int)2, null);
        }
        catch (IOException e) {
            throw new AllureResultsWriteException("Could not write Allure test result container", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull String source, @NotNull InputStream attachment) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        this.createDirectories(this.getOutputDirectory());
        File filePath = FilesKt.resolve((File)this.getOutputDirectory(), (String)source);
        try {
            Closeable closeable = attachment;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                long l;
                InputStream input = (InputStream)closeable;
                boolean bl3 = false;
                Object object = filePath;
                boolean bl4 = false;
                object = new FileOutputStream((File)object);
                bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)object;
                    boolean bl6 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new AllureResultsWriteException("Could not write Allure attachment", e);
        }
    }

    private final void createDirectories(File directory) {
        File parent = directory.getParentFile();
        File file = parent;
        if (Intrinsics.areEqual((Object)(file == null ? null : Boolean.valueOf(file.exists())), (Object)false)) {
            Intrinsics.checkNotNullExpressionValue((Object)parent, (String)"parent");
            this.createDirectories(parent);
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new AllureResultsWriteException("Could not create Allure results directory", null, 2, null);
        }
    }

    private final String generateTestResultContainerName(String uuid) {
        return Intrinsics.stringPlus((String)uuid, (Object)"-container.json");
    }

    static /* synthetic */ String generateTestResultContainerName$default(FileSystemResultsWriter fileSystemResultsWriter, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = UUID.randomUUID().toString();
        }
        return fileSystemResultsWriter.generateTestResultContainerName(string);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String generateTestResultName(@NotNull String uuid) {
        return Companion.generateTestResultName(uuid);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String generateTestResultName() {
        return Companion.generateTestResultName();
    }

    public static final /* synthetic */ Function0 access$getOutputDirectoryProvider$p(FileSystemResultsWriter $this) {
        return $this.outputDirectoryProvider;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lio/qameta/allure/kotlin/FileSystemResultsWriter$Companion;", "", "()V", "generateTestResultName", "", "uuid", "allure-kotlin-commons"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String generateTestResultName(@NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return Intrinsics.stringPlus((String)uuid, (Object)"-result.json");
        }

        public static /* synthetic */ String generateTestResultName$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                String string2 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
                string = string2;
            }
            return companion.generateTestResultName(string);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String generateTestResultName() {
            return io.qameta.allure.kotlin.FileSystemResultsWriter$Companion.generateTestResultName$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

