/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.kotlin;

import io.qameta.allure.kotlin.AllureResultsWriteException;
import io.qameta.allure.kotlin.AllureResultsWriter;
import io.qameta.allure.kotlin.OutputStreamResultsWriter;
import io.qameta.allure.kotlin.model.TestResult;
import io.qameta.allure.kotlin.model.TestResultContainer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B(\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\u00020\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/qameta/allure/kotlin/OutputStreamResultsWriter;", "Lio/qameta/allure/kotlin/AllureResultsWriter;", "streamProvider", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "Ljava/io/OutputStream;", "(Lkotlin/jvm/functions/Function1;)V", "mapper", "Lkotlinx/serialization/json/Json;", "generateTestResultContainerName", "uuid", "write", "", "testResult", "Lio/qameta/allure/kotlin/model/TestResult;", "testResultContainer", "Lio/qameta/allure/kotlin/model/TestResultContainer;", "source", "attachment", "Ljava/io/InputStream;", "Companion", "allure-kotlin-commons"})
public final class OutputStreamResultsWriter
implements AllureResultsWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, OutputStream> streamProvider;
    @NotNull
    private final Json mapper;

    public OutputStreamResultsWriter(@NotNull Function1<? super String, ? extends OutputStream> streamProvider) {
        Intrinsics.checkNotNullParameter(streamProvider, (String)"streamProvider");
        this.streamProvider = streamProvider;
        this.mapper = JsonKt.Json$default(null, (Function1)mapper.1.INSTANCE, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull TestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        String testResultName = Companion.generateTestResultName(testResult.getUuid());
        try {
            String json = this.mapper.encodeToString((SerializationStrategy)TestResult.Companion.serializer(), (Object)testResult);
            Closeable closeable = (Closeable)this.streamProvider.invoke((Object)testResultName);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl3 = false;
                String string = json;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                it.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new AllureResultsWriteException("Could not write Allure test result", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull TestResultContainer testResultContainer) {
        Intrinsics.checkNotNullParameter((Object)testResultContainer, (String)"testResultContainer");
        String testResultContainerName = this.generateTestResultContainerName(testResultContainer.getUuid());
        try {
            String json = this.mapper.encodeToString((SerializationStrategy)TestResultContainer.Companion.serializer(), (Object)testResultContainer);
            Closeable closeable = (Closeable)this.streamProvider.invoke((Object)testResultContainerName);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl3 = false;
                String string = json;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                it.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new AllureResultsWriteException("Could not write Allure test result container", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull String source, @NotNull InputStream attachment) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        try {
            Closeable closeable = attachment;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                long l;
                InputStream input = (InputStream)closeable;
                boolean bl3 = false;
                Closeable closeable2 = (Closeable)this.streamProvider.invoke((Object)source);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    OutputStream output = (OutputStream)closeable2;
                    boolean bl6 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new AllureResultsWriteException("Could not write Allure attachment", e);
        }
    }

    private final String generateTestResultContainerName(String uuid) {
        return Intrinsics.stringPlus((String)uuid, (Object)"-container.json");
    }

    static /* synthetic */ String generateTestResultContainerName$default(OutputStreamResultsWriter outputStreamResultsWriter, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = UUID.randomUUID().toString();
        }
        return outputStreamResultsWriter.generateTestResultContainerName(string);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String generateTestResultName(@NotNull String uuid) {
        return Companion.generateTestResultName(uuid);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String generateTestResultName() {
        return Companion.generateTestResultName();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lio/qameta/allure/kotlin/OutputStreamResultsWriter$Companion;", "", "()V", "generateTestResultName", "", "uuid", "allure-kotlin-commons"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String generateTestResultName(@NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return Intrinsics.stringPlus((String)uuid, (Object)"-result.json");
        }

        public static /* synthetic */ String generateTestResultName$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                String string2 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
                string = string2;
            }
            return companion.generateTestResultName(string);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String generateTestResultName() {
            return io.qameta.allure.kotlin.OutputStreamResultsWriter$Companion.generateTestResultName$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

