/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import io.qameta.allure.maven.AllureGenerateMojo;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="bulk", defaultPhase=LifecyclePhase.SITE, inheritByDefault=false)
public class AllureBulkMojo
extends AllureGenerateMojo {
    @Parameter(property="allure.results.inputDirectories")
    protected String inputDirectories;

    @Override
    protected List<Path> getInputDirectories() {
        ArrayList<Path> results = new ArrayList<Path>();
        for (String dir : this.inputDirectories.split(",")) {
            Path path = Paths.get(dir, new String[0]).toAbsolutePath();
            if (this.isDirectoryExists(path)) {
                results.add(path);
                this.getLog().info((CharSequence)("Found results directory " + path));
                continue;
            }
            this.getLog().warn((CharSequence)("Directory " + path + " not found."));
        }
        return results;
    }

    @Override
    protected String getMojoName() {
        return "bulk";
    }
}

