/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import io.qameta.allure.maven.VersionUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Proxy;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;

public class AllureCommandline {
    public static final String ALLURE_DEFAULT_VERSION = "2.30.0";
    private static final int DEFAULT_TIMEOUT = 3600;
    private final String version;
    private final int timeout;
    private final Path installationDirectory;

    public AllureCommandline(Path installationDirectory, String version) {
        this(installationDirectory, version, 3600);
    }

    public AllureCommandline(Path installationDirectory, String version, int timeout) {
        this.installationDirectory = installationDirectory;
        this.version = StringUtils.isBlank((CharSequence)version) || VersionUtils.versionCompare(version, "2.8.0") < 0 ? ALLURE_DEFAULT_VERSION : version;
        this.timeout = timeout;
    }

    public int generateReport(List<Path> resultsPaths, Path reportPath, boolean singleFile) throws IOException {
        this.checkAllureExists();
        FileUtils.deleteQuietly((File)reportPath.toFile());
        CommandLine commandLine = new CommandLine(this.getAllureExecutablePath().toAbsolutePath().toFile());
        commandLine.addArgument("generate");
        commandLine.addArgument("--clean");
        if (singleFile) {
            commandLine.addArgument("--single-file");
        }
        for (Path resultsPath : resultsPaths) {
            commandLine.addArgument(resultsPath.toAbsolutePath().toString(), true);
        }
        commandLine.addArgument("-o");
        commandLine.addArgument(reportPath.toAbsolutePath().toString(), true);
        return this.execute(commandLine, this.timeout);
    }

    public int serve(List<Path> resultsPaths, Path reportPath, String serveHost, Integer servePort) throws IOException {
        this.checkAllureExists();
        FileUtils.deleteQuietly((File)reportPath.toFile());
        CommandLine commandLine = new CommandLine(this.getAllureExecutablePath().toAbsolutePath().toFile());
        commandLine.addArgument("serve");
        if (serveHost != null && serveHost.matches("(\\d{1,3}\\.){3}\\d{1,3}")) {
            commandLine.addArgument("--host");
            commandLine.addArgument(serveHost);
        }
        if (servePort > 0) {
            commandLine.addArgument("--port");
            commandLine.addArgument(Objects.toString(servePort));
        }
        for (Path resultsPath : resultsPaths) {
            commandLine.addArgument(resultsPath.toAbsolutePath().toString(), true);
        }
        return this.execute(commandLine, this.timeout);
    }

    private void checkAllureExists() throws FileNotFoundException {
        if (this.allureNotExists()) {
            throw new FileNotFoundException("There is no valid allure installation. Make sure you're using allure version not less then 2.x.");
        }
    }

    private int execute(CommandLine commandLine, int timeout) throws IOException {
        DefaultExecutor executor = DefaultExecutor.builder().get();
        ExecuteWatchdog watchdog = ExecuteWatchdog.builder().setTimeout(Duration.ofMillis(TimeUnit.SECONDS.toMillis(timeout))).get();
        executor.setWatchdog(watchdog);
        executor.setExitValue(0);
        return executor.execute(commandLine);
    }

    private Path getAllureExecutablePath() {
        String allureExecutable = this.isWindows() ? "allure.bat" : "allure";
        return this.getAllureHome().resolve("bin").resolve(allureExecutable);
    }

    private Path getAllureHome() {
        return this.installationDirectory.resolve(String.format("allure-%s", this.version));
    }

    public boolean allureExists() {
        Path allureExecutablePath = this.getAllureExecutablePath();
        return Files.exists(allureExecutablePath, new LinkOption[0]) && Files.isExecutable(allureExecutablePath);
    }

    public boolean allureNotExists() {
        return !this.allureExists();
    }

    public void downloadWithMaven(MavenSession session, DependencyResolver dependencyResolver) throws IOException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        buildingRequest.setResolveDependencies(false);
        Dependency cliDep = new Dependency();
        cliDep.setGroupId("io.qameta.allure");
        cliDep.setArtifactId("allure-commandline");
        cliDep.setVersion(this.version);
        cliDep.setType("zip");
        try {
            Iterator resolved = dependencyResolver.resolveDependencies((ProjectBuildingRequest)buildingRequest, Collections.singletonList(cliDep), null, null).iterator();
            if (!resolved.hasNext()) {
                throw new IOException("No allure commandline artifact found.");
            }
            this.unpack(((ArtifactResult)resolved.next()).getArtifact().getFile());
        }
        catch (DependencyResolverException e) {
            throw new IOException("Cannot resolve allure commandline dependencies.", e);
        }
    }

    public void download(String allureDownloadUrl, Proxy mavenProxy) throws IOException {
        if (this.allureExists()) {
            return;
        }
        Path allureZip = Files.createTempFile("allure", this.version, new FileAttribute[0]);
        String allureUrl = String.format(allureDownloadUrl, this.version, this.version);
        URL url = new URL(allureUrl);
        if (mavenProxy != null && this.version != null) {
            InetSocketAddress proxyAddress = new InetSocketAddress(mavenProxy.getHost(), mavenProxy.getPort());
            if (mavenProxy.getUsername() != null && mavenProxy.getPassword() != null) {
                final String proxyUser = mavenProxy.getUsername();
                final String proxyPassword = mavenProxy.getPassword();
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
            }
            java.net.Proxy proxy = new java.net.Proxy(Proxy.Type.HTTP, proxyAddress);
            InputStream inputStream = url.openConnection(proxy).getInputStream();
            Files.copy(inputStream, allureZip, StandardCopyOption.REPLACE_EXISTING);
        } else {
            FileUtils.copyURLToFile((URL)url, (File)allureZip.toFile());
        }
        this.unpack(allureZip.toFile());
    }

    private void unpack(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            zipFile.extractAll(this.getInstallationDirectory().toAbsolutePath().toString());
        }
        catch (ZipException e) {
            throw new IOException(e);
        }
        Path allureExecutable = this.getAllureExecutablePath();
        if (Files.exists(allureExecutable, new LinkOption[0])) {
            allureExecutable.toFile().setExecutable(true);
        }
    }

    public Path getInstallationDirectory() {
        return this.installationDirectory;
    }

    public String getVersion() {
        return this.version;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }
}

