/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.Aggregator2;
import io.qameta.allure.Constants;
import io.qameta.allure.ReportStorage;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.metric.Metric;
import io.qameta.allure.metric.MetricLine;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class CommonMetricAggregator2
implements Aggregator2 {
    private final String location;
    private final String fileName;

    protected CommonMetricAggregator2(String fileName) {
        this("export", fileName);
    }

    protected CommonMetricAggregator2(String location, String fileName) {
        this.location = location;
        this.fileName = fileName;
    }

    @Override
    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, ReportStorage storage) {
        storage.addDataBinary(Constants.path(this.location, this.fileName), this.getData(launchesResults).getBytes(StandardCharsets.UTF_8));
    }

    public abstract List<Metric> getMetrics();

    protected String getData(List<LaunchResults> launchesResults) {
        List<Metric> metrics = this.getMetrics();
        List results = launchesResults.stream().map(LaunchResults::getAllResults).flatMap(Collection::stream).collect(Collectors.toList());
        for (TestResult result : results) {
            for (Metric metric : metrics) {
                metric.update(result);
            }
        }
        return metrics.stream().map(Metric::getLines).flatMap(Collection::stream).map(MetricLine::asString).collect(Collectors.joining("\n", "", "\n"));
    }
}

