/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.metric;

import io.qameta.allure.entity.GroupTime;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.metric.Metric;
import io.qameta.allure.metric.MetricLine;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

public class TimeMetric
implements Metric {
    private final GroupTime groupTime = new GroupTime();
    private final BiFunction<String, Long, MetricLine> lineFactory;

    public TimeMetric(BiFunction<String, Long, MetricLine> lineFactory) {
        this.lineFactory = lineFactory;
    }

    @Override
    public void update(TestResult testResult) {
        if (!testResult.isRetry()) {
            this.groupTime.update(testResult);
        }
    }

    @Override
    public List<MetricLine> getLines() {
        return Arrays.asList(this.lineFactory.apply("duration", TimeMetric.zeroIfNull(this.groupTime.getDuration())), this.lineFactory.apply("min_duration", TimeMetric.zeroIfNull(this.groupTime.getMinDuration())), this.lineFactory.apply("max_duration", TimeMetric.zeroIfNull(this.groupTime.getMaxDuration())), this.lineFactory.apply("sum_duration", TimeMetric.zeroIfNull(this.groupTime.getSumDuration())), this.lineFactory.apply("start", TimeMetric.zeroIfNull(this.groupTime.getStart())), this.lineFactory.apply("stop", TimeMetric.zeroIfNull(this.groupTime.getStop())));
    }

    private static long zeroIfNull(Long value) {
        return Objects.isNull(value) ? 0L : value;
    }
}

