/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.csv;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvBindByPosition;
import io.qameta.allure.entity.TestResult;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;

public class CsvExportSuite
implements Serializable {
    @CsvBindByName(column="Status")
    @CsvBindByPosition(position=0)
    private final String status;
    @CsvBindByName(column="Start Time")
    @CsvBindByPosition(position=1)
    private final String start;
    @CsvBindByName(column="Stop Time")
    @CsvBindByPosition(position=2)
    private final String stop;
    @CsvBindByName(column="Duration in ms")
    @CsvBindByPosition(position=3)
    private final String duration;
    @CsvBindByName(column="Parent Suite")
    @CsvBindByPosition(position=4)
    private final String parentSuite;
    @CsvBindByName(column="Suite")
    @CsvBindByPosition(position=5)
    private final String suite;
    @CsvBindByName(column="Sub Suite")
    @CsvBindByPosition(position=6)
    private final String subSuite;
    @CsvBindByName(column="Test Class")
    @CsvBindByPosition(position=7)
    private final String testClass;
    @CsvBindByName(column="Test Method")
    @CsvBindByPosition(position=8)
    private final String testMethod;
    @CsvBindByName(column="Name")
    @CsvBindByPosition(position=9)
    private final String name;
    @CsvBindByName(column="Description")
    @CsvBindByPosition(position=10)
    private final String description;

    public CsvExportSuite(TestResult result) {
        Map<String, String> resultMap = result.toMap();
        this.status = result.getStatus() != null ? result.getStatus().value() : null;
        this.duration = result.getTime().getDuration() != null ? result.getTime().getDuration().toString() : null;
        this.start = result.getTime().getStart() != null ? CsvExportSuite.asDate(result.getTime().getStart()) : null;
        this.stop = result.getTime().getStop() != null ? CsvExportSuite.asDate(result.getTime().getStop()) : null;
        this.parentSuite = resultMap.getOrDefault("parentSuite", null);
        this.suite = resultMap.getOrDefault("suite", null);
        this.subSuite = resultMap.getOrDefault("subSuite", null);
        this.testClass = resultMap.getOrDefault("testClass", null);
        this.testMethod = resultMap.getOrDefault("testMethod", null);
        this.name = result.getName();
        this.description = result.getDescription();
    }

    public String getStatus() {
        return this.status;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getStart() {
        return this.start;
    }

    public String getStop() {
        return this.stop;
    }

    public String getParentSuite() {
        return this.parentSuite;
    }

    public String getSuite() {
        return this.suite;
    }

    public String getSubSuite() {
        return this.subSuite;
    }

    public String getTestClass() {
        return this.testClass;
    }

    public String getTestMethod() {
        return this.testMethod;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    private static String asDate(Long epochMills) {
        if (Objects.nonNull(epochMills)) {
            return Instant.ofEpochMilli(epochMills).atZone(ZoneId.systemDefault()).toLocalDate().toString();
        }
        return null;
    }
}

