/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ClasspathEntityResolver
implements EntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathEntityResolver.class);
    private static final Pattern PATTERN = Pattern.compile("^.*/(.+\\.[dD][tT][dD]])$");
    private static final byte[] EMPTY_SCHEMA_BYTES = "".getBytes(StandardCharsets.UTF_8);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        Matcher matcher;
        if (Objects.nonNull(systemId) && (matcher = PATTERN.matcher(systemId)).matches()) {
            String schemaName = matcher.group();
            String resourceName = "dtd/" + schemaName;
            return this.classpathInputSource(publicId, systemId, resourceName);
        }
        return ClasspathEntityResolver.getInputSource(publicId, systemId, EMPTY_SCHEMA_BYTES);
    }

    private InputSource classpathInputSource(String publicId, String systemId, String resourceName) {
        byte[] schema = ClasspathEntityResolver.getBytes(resourceName);
        return ClasspathEntityResolver.getInputSource(publicId, systemId, schema);
    }

    private static InputSource getInputSource(String publicId, String systemId, byte[] schema) {
        InputSource inputSource = new InputSource(new ByteArrayInputStream(schema));
        inputSource.setPublicId(publicId);
        inputSource.setSystemId(systemId);
        inputSource.setEncoding(StandardCharsets.UTF_8.name());
        return inputSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getBytes(String resourceName) {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);){
            int temp;
            if (Objects.isNull(is)) {
                LOGGER.debug("schema resource {} not found", (Object)resourceName);
                byte[] byArray2 = EMPTY_SCHEMA_BYTES;
                return byArray2;
            }
            byte[] buffer = new byte[1000];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((temp = is.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, temp);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LOGGER.debug("can't read schema resource {}", (Object)resourceName, (Object)e);
            return EMPTY_SCHEMA_BYTES;
        }
    }
}

