/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.restassured;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.attachment.http.HttpRequestAttachment;
import io.qameta.allure.attachment.http.HttpResponseAttachment;
import io.restassured.filter.FilterContext;
import io.restassured.filter.OrderedFilter;
import io.restassured.internal.NameAndValue;
import io.restassured.internal.support.Prettifier;
import io.restassured.response.Response;
import io.restassured.response.ResponseOptions;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AllureRestAssured
implements OrderedFilter {
    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext filterContext) {
        Prettifier prettifier = new Prettifier();
        HttpRequestAttachment.Builder requestAttachmentBuilder = HttpRequestAttachment.Builder.create((String)"Request", (String)requestSpec.getURI()).withMethod(requestSpec.getMethod()).withHeaders(AllureRestAssured.toMapConverter((Iterable<? extends NameAndValue>)requestSpec.getHeaders())).withCookies(AllureRestAssured.toMapConverter((Iterable<? extends NameAndValue>)requestSpec.getCookies()));
        if (Objects.nonNull(requestSpec.getBody())) {
            requestAttachmentBuilder.withBody(prettifier.getPrettifiedBodyIfPossible(requestSpec));
        }
        HttpRequestAttachment requestAttachment = requestAttachmentBuilder.build();
        new DefaultAttachmentProcessor().addAttachment((AttachmentData)requestAttachment, (AttachmentRenderer)new FreemarkerAttachmentRenderer("http-request.ftl"));
        Response response = filterContext.next(requestSpec, responseSpec);
        HttpResponseAttachment responseAttachment = HttpResponseAttachment.Builder.create((String)response.getStatusLine()).withResponseCode(response.getStatusCode()).withHeaders(AllureRestAssured.toMapConverter((Iterable<? extends NameAndValue>)response.getHeaders())).withBody(prettifier.getPrettifiedBodyIfPossible((ResponseOptions)response, response.getBody())).build();
        new DefaultAttachmentProcessor().addAttachment((AttachmentData)responseAttachment, (AttachmentRenderer)new FreemarkerAttachmentRenderer("http-response.ftl"));
        return response;
    }

    private static Map<String, String> toMapConverter(Iterable<? extends NameAndValue> items) {
        HashMap<String, String> result = new HashMap<String, String>();
        items.forEach(h -> result.put(h.getName(), h.getValue()));
        return result;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

