/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.selenide;

import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ResultsUtils;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureSelenide
implements LogEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureSelenide.class);
    private boolean saveScreenshots = true;
    private boolean savePageHtml = true;
    private final AllureLifecycle lifecycle;

    public AllureSelenide() {
        this(Allure.getLifecycle());
    }

    public AllureSelenide(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureSelenide screenshots(boolean saveScreenshots) {
        this.saveScreenshots = saveScreenshots;
        return this;
    }

    public AllureSelenide savePageSource(boolean savePageHtml) {
        this.savePageHtml = savePageHtml;
        return this;
    }

    private static Optional<byte[]> getScreenshotBytes() {
        try {
            return Optional.of((TakesScreenshot)WebDriverRunner.getWebDriver()).map(wd -> (byte[])wd.getScreenshotAs(OutputType.BYTES));
        }
        catch (WebDriverException e) {
            LOGGER.warn("Could not get screen shot", (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<byte[]> getPageSourceBytes() {
        try {
            return Optional.of(WebDriverRunner.getWebDriver()).map(WebDriver::getPageSource).map(ps -> ps.getBytes(StandardCharsets.UTF_8));
        }
        catch (WebDriverException e) {
            LOGGER.warn("Could not get page source", (Throwable)e);
            return Optional.empty();
        }
    }

    public void beforeEvent(LogEvent event) {
        this.lifecycle.getCurrentTestCaseOrStep().ifPresent(parentUuid -> {
            String uuid = UUID.randomUUID().toString();
            this.lifecycle.startStep(parentUuid, uuid, new StepResult().setName(event.toString()));
        });
    }

    public void afterEvent(LogEvent event) {
        this.lifecycle.getCurrentTestCaseOrStep().ifPresent(parentUuid -> {
            switch (event.getStatus()) {
                case PASS: {
                    this.lifecycle.updateStep(step -> step.setStatus(Status.PASSED));
                    break;
                }
                case FAIL: {
                    if (this.saveScreenshots) {
                        AllureSelenide.getScreenshotBytes().ifPresent(bytes -> this.lifecycle.addAttachment("Screenshot", "image/png", "png", bytes));
                    }
                    if (this.savePageHtml) {
                        AllureSelenide.getPageSourceBytes().ifPresent(bytes -> this.lifecycle.addAttachment("Page source", "text/html", "html", bytes));
                    }
                    this.lifecycle.updateStep(stepResult -> {
                        stepResult.setStatus(ResultsUtils.getStatus((Throwable)event.getError()).orElse(Status.BROKEN));
                        stepResult.setStatusDetails(ResultsUtils.getStatusDetails((Throwable)event.getError()).orElse(new StatusDetails()));
                    });
                    break;
                }
                default: {
                    LOGGER.warn("Step finished with unsupported status {}", (Object)event.getStatus());
                }
            }
            this.lifecycle.stopStep();
        });
    }
}

