/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.spock2;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureId;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.testfilter.FileTestPlanSupplier;
import io.qameta.allure.testfilter.TestPlan;
import io.qameta.allure.testfilter.TestPlanV1_0;
import io.qameta.allure.util.AnnotationUtils;
import io.qameta.allure.util.ExceptionUtils;
import io.qameta.allure.util.ResultsUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.TestTag;

public class AllureSpock2
extends AbstractRunListener
implements IGlobalExtension {
    private final ThreadLocal<String> testResults = new InheritableThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return UUID.randomUUID().toString();
        }
    };
    private final AllureLifecycle lifecycle;
    private final TestPlan testPlan;

    public AllureSpock2() {
        this(Allure.getLifecycle());
    }

    public AllureSpock2(AllureLifecycle lifecycle) {
        this(lifecycle, new FileTestPlanSupplier().supply().orElse(null));
    }

    public AllureSpock2(AllureLifecycle lifecycle, TestPlan plan) {
        this.lifecycle = lifecycle;
        this.testPlan = plan;
    }

    public void visitSpec(SpecInfo spec) {
        spec.getAllFeatures().forEach(methodInfo -> methodInfo.setSkipped(this.isSkipped((FeatureInfo)methodInfo)));
        spec.addListener((IRunListener)this);
        String specContainerUuid = UUID.randomUUID().toString();
        spec.addInterceptor((IMethodInterceptor)new AllureContainerInterceptor(specContainerUuid));
        spec.getAllFixtureMethods().forEach(methodInfo -> {
            if (methodInfo.getKind().isSpecScopedFixtureMethod()) {
                methodInfo.addInterceptor((IMethodInterceptor)new AllureSpecFixtureMethodInterceptor(specContainerUuid));
            }
            if (methodInfo.getKind().isFeatureScopedFixtureMethod()) {
                methodInfo.addInterceptor((IMethodInterceptor)new AllureFeatureFixtureMethodInterceptor());
            }
        });
        spec.getAllFeatures().stream().map(FeatureInfo::getFeatureMethod).filter(Objects::nonNull).forEach(fm -> fm.addInterceptor(i -> {
            this.getLifecycle().getCurrentTestCaseOrStep().ifPresent(uuid -> this.getLifecycle().updateTestContainer(specContainerUuid, c -> c.getChildren().add(uuid)));
            i.proceed();
        }));
    }

    public void beforeIteration(IterationInfo iteration) {
        String uuid = this.testResults.get();
        FeatureInfo feature = iteration.getFeature();
        MethodInfo methodInfo = feature.getFeatureMethod();
        Method method = (Method)methodInfo.getReflection();
        Set featureLabels = AnnotationUtils.getLabels((AnnotatedElement)method);
        Set featureLinks = AnnotationUtils.getLinks((AnnotatedElement)method);
        SpecInfo specInfo = feature.getSpec();
        Class clazz = (Class)specInfo.getReflection();
        Set specLabels = AnnotationUtils.getLabels((AnnotatedElement)clazz);
        Set specLinks = AnnotationUtils.getLinks((AnnotatedElement)clazz);
        boolean flaky = AnnotationUtils.isFlaky((AnnotatedElement)method) || AnnotationUtils.isFlaky((AnnotatedElement)clazz);
        boolean muted = AnnotationUtils.isMuted((AnnotatedElement)method) || AnnotationUtils.isMuted((AnnotatedElement)clazz);
        List<Parameter> parameters = this.getParameters(feature.getDataVariables(), iteration.getDataValues());
        SpecInfo subSpec = specInfo.getSubSpec();
        SpecInfo superSpec = specInfo.getSuperSpec();
        String packageName = specInfo.getPackage();
        String specName = specInfo.getName();
        String testClassName = ((Class)feature.getSpec().getReflection()).getName();
        String testMethodName = iteration.getDisplayName();
        ArrayList<Label> labels = new ArrayList<Label>(Arrays.asList(ResultsUtils.createPackageLabel((String)packageName), ResultsUtils.createTestClassLabel((String)testClassName), ResultsUtils.createTestMethodLabel((String)testMethodName), ResultsUtils.createSuiteLabel((String)specName), ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createFrameworkLabel((String)"spock"), ResultsUtils.createLanguageLabel((String)"java")));
        if (Objects.nonNull(subSpec)) {
            labels.add(ResultsUtils.createSubSuiteLabel((String)subSpec.getName()));
        }
        if (Objects.nonNull(superSpec)) {
            labels.add(ResultsUtils.createParentSuiteLabel((String)superSpec.getName()));
        }
        List testTags = feature.getTestTags().stream().map(TestTag::getValue).map(ResultsUtils::createTagLabel).collect(Collectors.toList());
        labels.addAll(testTags);
        labels.addAll(featureLabels);
        labels.addAll(specLabels);
        labels.addAll(ResultsUtils.getProvidedLabels());
        ArrayList links = new ArrayList(featureLinks);
        links.addAll(specLinks);
        String qualifiedName = this.getQualifiedName(iteration);
        TestResult result = new TestResult().setUuid(uuid).setHistoryId(this.getHistoryId(qualifiedName, parameters)).setTestCaseName(iteration.getName()).setTestCaseId(ResultsUtils.md5((String)qualifiedName)).setFullName(qualifiedName).setName(ResultsUtils.firstNonEmpty((String[])new String[]{testMethodName, iteration.getName(), qualifiedName}).orElse("Unknown")).setStatusDetails(new StatusDetails().setFlaky(flaky).setMuted(muted)).setParameters(parameters).setLinks(links).setLabels(labels);
        ResultsUtils.processDescription((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (Method)method, arg_0 -> ((TestResult)result).setDescription(arg_0), arg_0 -> ((TestResult)result).setDescriptionHtml(arg_0));
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().startTestCase(uuid);
    }

    private String getQualifiedName(IterationInfo iteration) {
        return this.getQualifiedName(((Class)iteration.getFeature().getSpec().getReflection()).getName(), iteration.getName());
    }

    private String getQualifiedName(FeatureInfo featureInfo) {
        return this.getQualifiedName(((Class)featureInfo.getSpec().getReflection()).getName(), featureInfo.getName());
    }

    private String getQualifiedName(String specName, String testName) {
        return specName + "." + testName;
    }

    private String getHistoryId(String name, List<Parameter> parameters) {
        MessageDigest digest = ResultsUtils.getMd5Digest();
        digest.update(name.getBytes(StandardCharsets.UTF_8));
        parameters.stream().sorted(Comparator.comparing(Parameter::getName).thenComparing(Parameter::getValue)).forEachOrdered(parameter -> {
            digest.update(parameter.getName().getBytes(StandardCharsets.UTF_8));
            digest.update(parameter.getValue().getBytes(StandardCharsets.UTF_8));
        });
        byte[] bytes = digest.digest();
        return ResultsUtils.bytesToHex((byte[])bytes);
    }

    private boolean isSkipped(FeatureInfo featureInfo) {
        if (Objects.isNull(this.testPlan)) {
            return false;
        }
        if (this.testPlan instanceof TestPlanV1_0) {
            TestPlanV1_0 tp = (TestPlanV1_0)this.testPlan;
            return !Objects.isNull(tp.getTests()) && tp.getTests().stream().filter(Objects::nonNull).noneMatch(tc -> this.match((TestPlanV1_0.TestCase)tc, this.getAllureId(featureInfo), this.getQualifiedName(featureInfo)));
        }
        return false;
    }

    private String getAllureId(FeatureInfo featureInfo) {
        AllureId annotation = (AllureId)featureInfo.getFeatureMethod().getAnnotation(AllureId.class);
        if (Objects.nonNull(annotation)) {
            return annotation.value();
        }
        return null;
    }

    private boolean match(TestPlanV1_0.TestCase tc, String allureId, String qualifiedName) {
        return Objects.equals(allureId, tc.getId()) || Objects.equals(qualifiedName, tc.getSelector());
    }

    public void error(ErrorInfo error) {
        String uuid = this.testResults.get();
        this.getLifecycle().updateTestCase(uuid, testResult -> testResult.setStatus((Status)ResultsUtils.getStatus((Throwable)error.getException()).orElse(null)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)error.getException()).orElse(null)));
    }

    public void afterIteration(IterationInfo iteration) {
        String uuid = this.testResults.get();
        this.testResults.remove();
        this.getLifecycle().updateTestCase(uuid, testResult -> {
            if (Objects.isNull(testResult.getStatus())) {
                testResult.setStatus(Status.PASSED);
            }
        });
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    private List<Parameter> getParameters(List<String> names, Object ... values) {
        return IntStream.range(0, Math.min(names.size(), values.length)).mapToObj(index -> ResultsUtils.createParameter((String)((String)names.get(index)), (Object)values[index])).collect(Collectors.toList());
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    private class AllureContainerInterceptor
    implements IMethodInterceptor {
        private final String containerUuid;

        private AllureContainerInterceptor(String containerUuid) {
            this.containerUuid = containerUuid;
        }

        public void intercept(IMethodInvocation invocation) throws Throwable {
            TestResultContainer container = new TestResultContainer().setUuid(this.containerUuid);
            AllureSpock2.this.getLifecycle().startTestContainer(container);
            try {
                invocation.proceed();
            }
            finally {
                AllureSpock2.this.getLifecycle().stopTestContainer(this.containerUuid);
                AllureSpock2.this.getLifecycle().writeTestContainer(this.containerUuid);
            }
        }
    }

    private class AllureSpecFixtureMethodInterceptor
    implements IMethodInterceptor {
        protected final String containerUuid;

        private AllureSpecFixtureMethodInterceptor(String containerUuid) {
            this.containerUuid = containerUuid;
        }

        public void intercept(IMethodInvocation invocation) throws Throwable {
            String fixtureUuid = UUID.randomUUID().toString();
            MethodKind kind = invocation.getMethod().getKind();
            String fixtureName = kind.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
            FixtureResult fixtureResult = new FixtureResult().setName(fixtureName);
            if (kind.isSetupMethod()) {
                AllureSpock2.this.getLifecycle().startPrepareFixture(this.containerUuid, fixtureUuid, fixtureResult);
            } else {
                AllureSpock2.this.getLifecycle().startTearDownFixture(this.containerUuid, fixtureUuid, fixtureResult);
            }
            try {
                invocation.proceed();
                AllureSpock2.this.getLifecycle().updateFixture(fixtureUuid, f -> f.setStatus(Status.PASSED));
            }
            catch (Throwable throwable) {
                AllureSpock2.this.getLifecycle().updateFixture(fixtureUuid, f -> f.setStatus(ResultsUtils.getStatus((Throwable)throwable).orElse(Status.BROKEN)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)throwable).orElse(null)));
                throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)throwable);
            }
            finally {
                AllureSpock2.this.getLifecycle().stopFixture(fixtureUuid);
            }
        }
    }

    private class AllureFeatureFixtureMethodInterceptor
    extends AllureSpecFixtureMethodInterceptor {
        private AllureFeatureFixtureMethodInterceptor() {
            this(UUID.randomUUID().toString());
        }

        private AllureFeatureFixtureMethodInterceptor(String containerUuid) {
            super(containerUuid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            String uuid = AllureSpock2.this.getLifecycle().getCurrentTestCase().orElse(null);
            if (Objects.isNull(uuid)) {
                invocation.proceed();
                return;
            }
            TestResultContainer container = new TestResultContainer().setUuid(this.containerUuid);
            container.getChildren().add(uuid);
            AllureSpock2.this.getLifecycle().startTestContainer(container);
            try {
                super.intercept(invocation);
            }
            finally {
                AllureSpock2.this.getLifecycle().stopTestContainer(this.containerUuid);
                AllureSpock2.this.getLifecycle().writeTestContainer(this.containerUuid);
                AllureSpock2.this.getLifecycle().setCurrentTestCase(uuid);
            }
        }
    }
}

