/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.spock2.compiler;

import io.qameta.allure.Allure;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ErrorReporter;
import org.spockframework.compiler.SourceLookup;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class AllureStatementsLabelsToStepsTransformation
implements ASTTransformation {
    public void visit(ASTNode[] nodes, SourceUnit sourceUnit) {
        new Impl().visit(sourceUnit);
    }

    private static final class Impl {
        private static final AstNodeCache NODE_CACHE = new AstNodeCache();

        private Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void visit(SourceUnit sourceUnit) {
            ErrorReporter errorReporter = new ErrorReporter(sourceUnit);
            try (SourceLookup sourceLookup = new SourceLookup(sourceUnit);){
                sourceUnit.getAST().getClasses().stream().filter(this::isSpec).forEach(clazz -> this.processSpec(sourceUnit, (ClassNode)clazz, errorReporter));
            }
        }

        private boolean isSpec(ClassNode clazz) {
            return clazz.isDerivedFrom(Impl.NODE_CACHE.Specification);
        }

        private void processSpec(SourceUnit sourceUnit, ClassNode clazz, ErrorReporter errorReporter) {
            try {
                clazz.visitContents((GroovyClassVisitor)new MethodVisitor());
                if (!sourceUnit.getErrorCollector().hasErrors()) {
                    new VariableScopeVisitor(sourceUnit).visitClass(clazz);
                }
            }
            catch (Exception e) {
                errorReporter.error("Unexpected error during compilation of spec '%s'. Please file a bug report at https://github.com/allure-framework/allure-java.", (Throwable)e, new Object[]{clazz.getName()});
            }
        }
    }

    private static final class MethodVisitor
    implements GroovyClassVisitor {
        private static final ClassNode ALLURE = ClassHelper.makeWithoutCaching(Allure.class);

        private MethodVisitor() {
        }

        public void visitClass(ClassNode node) {
        }

        public void visitConstructor(ConstructorNode node) {
        }

        public void visitMethod(MethodNode node) {
            List newStatements = AstUtil.getStatements((MethodNode)node).stream().flatMap(statement -> Stream.concat(MethodVisitor.getAllureStepStatements(statement), Stream.of(statement))).collect(Collectors.toList());
            node.setCode((Statement)new BlockStatement(newStatements, ((BlockStatement)node.getCode()).getVariableScope()));
        }

        public void visitField(FieldNode node) {
        }

        public void visitProperty(PropertyNode node) {
        }

        private static Stream<Statement> getAllureStepStatements(Statement statement) {
            if (Objects.nonNull(statement.getStatementLabels()) && !statement.getStatementLabels().isEmpty()) {
                Object value;
                ExpressionStatement es;
                String labels = String.join((CharSequence)" ", statement.getStatementLabels());
                StringBuilder builder = new StringBuilder(labels);
                if (statement instanceof ExpressionStatement && (es = (ExpressionStatement)statement).getExpression() instanceof ConstantExpression && (value = ((ConstantExpression)es.getExpression()).getValue()) instanceof String) {
                    builder.append(": ").append(value);
                }
                String stepName = builder.toString();
                return Stream.of(new ExpressionStatement((Expression)new StaticMethodCallExpression(ALLURE, "step", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)stepName)))));
            }
            return Stream.empty();
        }
    }
}

