/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.testng;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Epic;
import io.qameta.allure.Feature;
import io.qameta.allure.Flaky;
import io.qameta.allure.Issue;
import io.qameta.allure.Link;
import io.qameta.allure.Muted;
import io.qameta.allure.Owner;
import io.qameta.allure.Severity;
import io.qameta.allure.Story;
import io.qameta.allure.TmsLink;
import io.qameta.allure.model.ExecutableItem;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.util.ResultsUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener2;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ConstructorOrMethod;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class AllureTestNg
implements ISuiteListener,
ITestListener,
IInvokedMethodListener2 {
    private static final String ALLURE_UUID = "ALLURE_UUID";
    private static final String MD_5 = "md5";
    private final ThreadLocal<Current> currentTestResult = new InheritableThreadLocal<Current>(){

        @Override
        protected Current initialValue() {
            return new Current();
        }
    };
    private final ThreadLocal<String> currentTestContainer = new InheritableThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return UUID.randomUUID().toString();
        }
    };
    private final ThreadLocal<String> currentExecutable = new InheritableThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return UUID.randomUUID().toString();
        }
    };
    private final Map<ITestClass, String> classContainerUuidStorage = new ConcurrentHashMap<ITestClass, String>();
    private final AllureLifecycle lifecycle;

    public AllureTestNg(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureTestNg() {
        this.lifecycle = Allure.getLifecycle();
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void onStart(ISuite suite) {
        TestResultContainer result = new TestResultContainer().withUuid(this.getUniqueUuid((IAttributes)suite)).withName(suite.getName()).withStart(Long.valueOf(System.currentTimeMillis()));
        this.getLifecycle().startTestContainer(result);
    }

    public void onStart(ITestContext context) {
        String parentUuid = this.getUniqueUuid((IAttributes)context.getSuite());
        String uuid = this.getUniqueUuid((IAttributes)context);
        TestResultContainer container = new TestResultContainer().withUuid(uuid).withName(context.getName()).withStart(Long.valueOf(System.currentTimeMillis()));
        this.getLifecycle().startTestContainer(parentUuid, container);
        Stream.of(context.getAllTestMethods()).map(ITestNGMethod::getTestClass).distinct().forEach(this::onBeforeClass);
    }

    public void onFinish(ISuite suite) {
        String uuid = this.getUniqueUuid((IAttributes)suite);
        this.getLifecycle().stopTestContainer(uuid);
        this.getLifecycle().writeTestContainer(uuid);
    }

    public void onFinish(ITestContext context) {
        String uuid = this.getUniqueUuid((IAttributes)context);
        this.getLifecycle().stopTestContainer(uuid);
        this.getLifecycle().writeTestContainer(uuid);
        Stream.of(context.getAllTestMethods()).map(ITestNGMethod::getTestClass).distinct().forEach(this::onAfterClass);
    }

    public void onBeforeClass(ITestClass testClass) {
        String uuid = UUID.randomUUID().toString();
        TestResultContainer container = new TestResultContainer().withUuid(uuid).withName(testClass.getName());
        this.getLifecycle().startTestContainer(container);
        this.classContainerUuidStorage.put(testClass, uuid);
    }

    public void onAfterClass(ITestClass testClass) {
        if (!this.classContainerUuidStorage.containsKey(testClass)) {
            return;
        }
        String uuid = this.classContainerUuidStorage.get(testClass);
        this.getLifecycle().stopTestContainer(uuid);
        this.getLifecycle().writeTestContainer(uuid);
    }

    public void onTestStart(ITestResult testResult) {
        Current current = this.currentTestResult.get();
        if (current.isStarted()) {
            current = this.refreshContext();
        }
        current.test();
        String parentUuid = this.getUniqueUuid((IAttributes)testResult.getTestContext());
        ITestNGMethod method = testResult.getMethod();
        ITestClass testClass = method.getTestClass();
        ArrayList<Label> labels = new ArrayList<Label>();
        labels.addAll(Arrays.asList(new Label().withName("package").withValue(testClass.getName()), new Label().withName("testClass").withValue(testClass.getName()), new Label().withName("testMethod").withValue(method.getMethodName()), new Label().withName("parentSuite").withValue(AllureTestNg.safeExtractSuiteName(testClass)), new Label().withName("suite").withValue(AllureTestNg.safeExtractTestTag(testClass)), new Label().withName("subSuite").withValue(AllureTestNg.safeExtractTestClassName(testClass)), new Label().withName("host").withValue(ResultsUtils.getHostName()), new Label().withName("thread").withValue(ResultsUtils.getThreadName())));
        labels.addAll(this.getLabels(testResult));
        List<io.qameta.allure.model.Parameter> parameters = this.getParameters(testResult);
        TestResult result = new TestResult().withUuid(current.getUuid()).withHistoryId(this.getHistoryId(method, parameters)).withName(this.getMethodName(method)).withFullName(this.getQualifiedName(method)).withStatusDetails(new StatusDetails().withFlaky(this.isFlaky(testResult)).withMuted(this.isMuted(testResult))).withParameters(parameters).withLinks(this.getLinks(testResult)).withLabels(labels);
        ResultsUtils.processDescription((ClassLoader)this.getClass().getClassLoader(), (Method)method.getConstructorOrMethod().getMethod(), (ExecutableItem)result);
        this.getLifecycle().scheduleTestCase(parentUuid, result);
        this.getLifecycle().startTestCase(current.getUuid());
        String uuid = current.getUuid();
        Optional.of(testResult).map(ITestResult::getMethod).map(ITestNGMethod::getTestClass).map(this.classContainerUuidStorage::get).ifPresent(testClassContainerUuid -> this.getLifecycle().updateTestContainer(testClassContainerUuid, container -> container.getChildren().add(uuid)));
    }

    public void onTestSuccess(ITestResult testResult) {
        Current current = this.currentTestResult.get();
        current.after();
        this.getLifecycle().updateTestCase(current.getUuid(), this.setStatus(Status.PASSED));
        this.getLifecycle().stopTestCase(current.getUuid());
        this.getLifecycle().writeTestCase(current.getUuid());
    }

    public void onTestFailure(ITestResult result) {
        Current current = this.currentTestResult.get();
        if (current.isAfter()) {
            current = this.refreshContext();
        }
        if (!current.isStarted()) {
            this.createTestResultForTestWithoutSetup(result);
        }
        current.after();
        Throwable throwable = result.getThrowable();
        Status status = this.getStatus(throwable);
        StatusDetails details = ResultsUtils.getStatusDetails((Throwable)throwable).orElse(null);
        this.getLifecycle().updateTestCase(current.getUuid(), this.setStatus(status, details));
        this.getLifecycle().stopTestCase(current.getUuid());
        this.getLifecycle().writeTestCase(current.getUuid());
    }

    public void onTestSkipped(ITestResult result) {
        Current current = this.currentTestResult.get();
        if (current.isAfter()) {
            current = this.refreshContext();
        }
        if (!current.isStarted()) {
            this.createTestResultForTestWithoutSetup(result);
        }
        current.after();
        StatusDetails details = ResultsUtils.getStatusDetails((Throwable)result.getThrowable()).orElse(null);
        this.getLifecycle().updateTestCase(current.getUuid(), this.setStatus(Status.SKIPPED, details));
        this.getLifecycle().stopTestCase(current.getUuid());
        this.getLifecycle().writeTestCase(current.getUuid());
    }

    private void createTestResultForTestWithoutSetup(ITestResult result) {
        this.onTestStart(result);
        this.currentTestResult.remove();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
        ITestNGMethod testMethod = method.getTestMethod();
        if (this.isSupportedConfigurationFixture(testMethod)) {
            this.ifSuiteFixtureStarted(context.getSuite(), testMethod);
            this.ifTestFixtureStarted(context, testMethod);
            this.ifClassFixtureStarted(testMethod);
            this.ifMethodFixtureStarted(testMethod);
        }
    }

    private void ifSuiteFixtureStarted(ISuite suite, ITestNGMethod testMethod) {
        if (testMethod.isBeforeSuiteConfiguration()) {
            this.startBefore(this.getUniqueUuid((IAttributes)suite), testMethod);
        }
        if (testMethod.isAfterSuiteConfiguration()) {
            this.startAfter(this.getUniqueUuid((IAttributes)suite), testMethod);
        }
    }

    private void ifClassFixtureStarted(ITestNGMethod testMethod) {
        String parentUuid;
        if (testMethod.isBeforeClassConfiguration()) {
            parentUuid = this.classContainerUuidStorage.get(testMethod.getTestClass());
            this.startBefore(parentUuid, testMethod);
        }
        if (testMethod.isAfterClassConfiguration()) {
            parentUuid = this.classContainerUuidStorage.get(testMethod.getTestClass());
            this.startAfter(parentUuid, testMethod);
        }
    }

    private void ifTestFixtureStarted(ITestContext context, ITestNGMethod testMethod) {
        if (testMethod.isBeforeTestConfiguration()) {
            this.startBefore(this.getUniqueUuid((IAttributes)context), testMethod);
        }
        if (testMethod.isAfterTestConfiguration()) {
            this.startAfter(this.getUniqueUuid((IAttributes)context), testMethod);
        }
    }

    private void startBefore(String parentUuid, ITestNGMethod method) {
        String uuid = this.currentExecutable.get();
        this.getLifecycle().startPrepareFixture(parentUuid, uuid, this.getFixtureResult(method));
    }

    private void startAfter(String parentUuid, ITestNGMethod method) {
        String uuid = this.currentExecutable.get();
        this.getLifecycle().startTearDownFixture(parentUuid, uuid, this.getFixtureResult(method));
    }

    private void ifMethodFixtureStarted(ITestNGMethod testMethod) {
        this.currentTestContainer.remove();
        Current current = this.currentTestResult.get();
        FixtureResult fixture = this.getFixtureResult(testMethod);
        String uuid = this.currentExecutable.get();
        if (testMethod.isBeforeMethodConfiguration()) {
            if (current.isStarted()) {
                this.currentTestResult.remove();
                current = this.currentTestResult.get();
            }
            this.getLifecycle().startPrepareFixture(this.createFakeContainer(testMethod, current), uuid, fixture);
        }
        if (testMethod.isAfterMethodConfiguration()) {
            this.getLifecycle().startTearDownFixture(this.createFakeContainer(testMethod, current), uuid, fixture);
        }
    }

    private String createFakeContainer(ITestNGMethod method, Current current) {
        String parentUuid = this.currentTestContainer.get();
        TestResultContainer container = new TestResultContainer().withUuid(parentUuid).withName(this.getQualifiedName(method)).withStart(Long.valueOf(System.currentTimeMillis())).withDescription(method.getDescription()).withChildren(new String[]{current.getUuid()});
        this.getLifecycle().startTestContainer(container);
        return parentUuid;
    }

    private String getQualifiedName(ITestNGMethod method) {
        return method.getRealClass().getName() + "." + method.getMethodName();
    }

    private FixtureResult getFixtureResult(ITestNGMethod method) {
        return new FixtureResult().withName(this.getMethodName(method)).withStart(Long.valueOf(System.currentTimeMillis())).withDescription(method.getDescription()).withStage(Stage.RUNNING);
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
        ITestNGMethod testMethod = method.getTestMethod();
        if (this.isSupportedConfigurationFixture(testMethod)) {
            String executableUuid = this.currentExecutable.get();
            this.currentExecutable.remove();
            if (testResult.isSuccess()) {
                this.getLifecycle().updateFixture(executableUuid, result -> result.withStatus(Status.PASSED));
            } else {
                this.getLifecycle().updateFixture(executableUuid, result -> result.withStatus(this.getStatus(testResult.getThrowable())).withStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)testResult.getThrowable()).orElse(null)));
            }
            this.getLifecycle().stopFixture(executableUuid);
            if (testMethod.isBeforeMethodConfiguration() || testMethod.isAfterMethodConfiguration()) {
                String containerUuid = this.currentTestContainer.get();
                this.validateContainerExists(this.getQualifiedName(testMethod), containerUuid);
                this.currentTestContainer.remove();
                this.getLifecycle().stopTestContainer(containerUuid);
                this.getLifecycle().writeTestContainer(containerUuid);
            }
        }
    }

    protected String getHistoryId(ITestNGMethod method, List<io.qameta.allure.model.Parameter> parameters) {
        MessageDigest digest = this.getMessageDigest();
        String testClassName = method.getTestClass().getName();
        String methodName = method.getMethodName();
        digest.update(testClassName.getBytes(StandardCharsets.UTF_8));
        digest.update(methodName.getBytes(StandardCharsets.UTF_8));
        parameters.stream().sorted(Comparator.comparing(io.qameta.allure.model.Parameter::getName).thenComparing(io.qameta.allure.model.Parameter::getValue)).forEachOrdered(parameter -> {
            digest.update(parameter.getName().getBytes(StandardCharsets.UTF_8));
            digest.update(parameter.getValue().getBytes(StandardCharsets.UTF_8));
        });
        byte[] bytes = digest.digest();
        return new BigInteger(1, bytes).toString(16);
    }

    protected Status getStatus(Throwable throwable) {
        return ResultsUtils.getStatus((Throwable)throwable).orElse(Status.BROKEN);
    }

    private boolean isSupportedConfigurationFixture(ITestNGMethod testMethod) {
        return testMethod.isBeforeMethodConfiguration() || testMethod.isAfterMethodConfiguration() || testMethod.isBeforeTestConfiguration() || testMethod.isAfterTestConfiguration() || testMethod.isBeforeClassConfiguration() || testMethod.isAfterClassConfiguration() || testMethod.isBeforeSuiteConfiguration() || testMethod.isAfterSuiteConfiguration();
    }

    private void validateContainerExists(String fixtureName, String containerUuid) {
        if (Objects.isNull(containerUuid)) {
            throw new IllegalStateException("Could not find container for after method fixture " + fixtureName);
        }
    }

    private List<Label> getLabels(ITestResult result) {
        return Stream.of(this.getLabels(result, Epic.class, ResultsUtils::createLabel), this.getLabels(result, Feature.class, ResultsUtils::createLabel), this.getLabels(result, Story.class, ResultsUtils::createLabel), this.getLabels(result, Severity.class, ResultsUtils::createLabel), this.getLabels(result, Owner.class, ResultsUtils::createLabel)).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private <T extends Annotation> Stream<Label> getLabels(ITestResult result, Class<T> clazz, Function<T, Label> extractor) {
        List onMethod = this.getAnnotationsOnMethod(result, clazz).stream().map(extractor).collect(Collectors.toList());
        if (!onMethod.isEmpty()) {
            return onMethod.stream();
        }
        return this.getAnnotationsOnClass(result, clazz).stream().map(extractor);
    }

    private List<io.qameta.allure.model.Link> getLinks(ITestResult result) {
        return Stream.of(this.getAnnotationsOnClass(result, Link.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnMethod(result, Link.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnClass(result, Issue.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnMethod(result, Issue.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnClass(result, TmsLink.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnMethod(result, TmsLink.class).stream().map(ResultsUtils::createLink)).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private boolean isFlaky(ITestResult result) {
        return this.hasAnnotation(result, Flaky.class);
    }

    private boolean isMuted(ITestResult result) {
        return this.hasAnnotation(result, Muted.class);
    }

    private boolean hasAnnotation(ITestResult result, Class<? extends Annotation> clazz) {
        return this.hasAnnotationOnMethod(result, clazz) || this.hasAnnotationOnClass(result, clazz);
    }

    private boolean hasAnnotationOnClass(ITestResult result, Class<? extends Annotation> clazz) {
        return !this.getAnnotationsOnClass(result, clazz).isEmpty();
    }

    private boolean hasAnnotationOnMethod(ITestResult result, Class<? extends Annotation> clazz) {
        return !this.getAnnotationsOnMethod(result, clazz).isEmpty();
    }

    private <T extends Annotation> List<T> getAnnotationsOnMethod(ITestResult result, Class<T> clazz) {
        return Stream.of(result).map(ITestResult::getMethod).filter(Objects::nonNull).map(ITestNGMethod::getConstructorOrMethod).map(ConstructorOrMethod::getMethod).flatMap(method -> Stream.of(method.getAnnotationsByType(clazz))).collect(Collectors.toList());
    }

    private <T extends Annotation> List<T> getAnnotationsOnClass(ITestResult result, Class<T> clazz) {
        return Stream.of(result).map(ITestResult::getTestClass).filter(Objects::nonNull).map(IClass::getRealClass).flatMap(aClass -> Stream.of(aClass.getAnnotationsByType(clazz))).map(clazz::cast).collect(Collectors.toList());
    }

    private String getUniqueUuid(IAttributes suite) {
        if (Objects.isNull(suite.getAttribute(ALLURE_UUID))) {
            suite.setAttribute(ALLURE_UUID, (Object)UUID.randomUUID().toString());
        }
        return Objects.toString(suite.getAttribute(ALLURE_UUID));
    }

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(MD_5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not find md5 hashing algorithm", e);
        }
    }

    private static String safeExtractSuiteName(ITestClass testClass) {
        Optional<XmlTest> xmlTest = Optional.ofNullable(testClass.getXmlTest());
        return xmlTest.map(XmlTest::getSuite).map(XmlSuite::getName).orElse("Undefined suite");
    }

    private static String safeExtractTestTag(ITestClass testClass) {
        Optional<XmlTest> xmlTest = Optional.ofNullable(testClass.getXmlTest());
        return xmlTest.map(XmlTest::getName).orElse("Undefined testng tag");
    }

    private static String safeExtractTestClassName(ITestClass testClass) {
        return ResultsUtils.firstNonEmpty((String[])new String[]{testClass.getTestName(), testClass.getName()}).orElse("Undefined class name");
    }

    private List<io.qameta.allure.model.Parameter> getParameters(ITestResult testResult) {
        Stream<io.qameta.allure.model.Parameter> tagsParameters = testResult.getTestContext().getCurrentXmlTest().getAllParameters().entrySet().stream().map(entry -> new io.qameta.allure.model.Parameter().withName((String)entry.getKey()).withValue((String)entry.getValue()));
        String[] parameterNames = (String[])Optional.of(testResult).map(ITestResult::getMethod).map(ITestNGMethod::getConstructorOrMethod).map(ConstructorOrMethod::getMethod).map(Executable::getParameters).map(Stream::of).orElseGet(Stream::empty).map(Parameter::getName).toArray(String[]::new);
        String[] parameterValues = (String[])Stream.of(testResult.getParameters()).map(this::convertParameterValueToString).toArray(String[]::new);
        Stream<io.qameta.allure.model.Parameter> methodParameters = IntStream.range(0, Math.min(parameterNames.length, parameterValues.length)).mapToObj(i -> new io.qameta.allure.model.Parameter().withName(parameterNames[i]).withValue(parameterValues[i]));
        return Stream.concat(tagsParameters, methodParameters).collect(Collectors.toList());
    }

    private String convertParameterValueToString(Object parameter) {
        if (Objects.nonNull(parameter) && parameter.getClass().isArray()) {
            return Arrays.toString((Object[])parameter);
        }
        return Objects.toString(parameter);
    }

    private String getMethodName(ITestNGMethod method) {
        return ResultsUtils.firstNonEmpty((String[])new String[]{method.getDescription(), method.getMethodName(), this.getQualifiedName(method)}).orElse("Unknown");
    }

    private Consumer<TestResult> setStatus(Status status) {
        return result -> result.withStatus(status);
    }

    private Consumer<TestResult> setStatus(Status status, StatusDetails details) {
        return result -> {
            result.setStatus(status);
            if (Objects.nonNull(details)) {
                result.getStatusDetails().setTrace(details.getTrace());
                result.getStatusDetails().setMessage(details.getMessage());
            }
        };
    }

    private Current refreshContext() {
        this.currentTestResult.remove();
        return this.currentTestResult.get();
    }

    private static enum CurrentStage {
        BEFORE,
        TEST,
        AFTER;

    }

    private static class Current {
        private final String uuid = UUID.randomUUID().toString();
        private CurrentStage currentStage = CurrentStage.BEFORE;

        Current() {
        }

        public void test() {
            this.currentStage = CurrentStage.TEST;
        }

        public void after() {
            this.currentStage = CurrentStage.AFTER;
        }

        public boolean isStarted() {
            return this.currentStage != CurrentStage.BEFORE;
        }

        public boolean isAfter() {
            return this.currentStage == CurrentStage.AFTER;
        }

        public String getUuid() {
            return this.uuid;
        }
    }
}

