/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.atlas.webdriver.extension;

import io.qameta.atlas.core.AtlasException;
import io.qameta.atlas.core.api.MethodExtension;
import io.qameta.atlas.core.internal.Configuration;
import io.qameta.atlas.core.util.MethodInfo;
import io.qameta.atlas.webdriver.context.WebDriverContext;
import java.lang.reflect.Method;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class ExecuteJScriptMethodExtension
implements MethodExtension {
    private static final String EXECUTE_SCRIPT = "executeScript";

    public boolean test(Method method) {
        return EXECUTE_SCRIPT.equals(method.getName());
    }

    public Object invoke(Object proxy, MethodInfo methodInfo, Configuration configuration) {
        WebDriver driver = ((WebDriverContext)configuration.getContext(WebDriverContext.class).orElseThrow(() -> new AtlasException("WebDriver is missing"))).getValue();
        String script = (String)methodInfo.getArgs()[0];
        JavascriptExecutor js = (JavascriptExecutor)driver;
        js.executeScript(script, new Object[]{proxy});
        return proxy;
    }
}

