/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.atlas.webdriver.extension;

import io.qameta.atlas.core.Atlas;
import io.qameta.atlas.core.api.Context;
import io.qameta.atlas.core.api.MethodExtension;
import io.qameta.atlas.core.api.Retry;
import io.qameta.atlas.core.api.Target;
import io.qameta.atlas.core.context.RetryerContext;
import io.qameta.atlas.core.internal.Configuration;
import io.qameta.atlas.core.internal.DefaultRetryer;
import io.qameta.atlas.core.internal.Retryer;
import io.qameta.atlas.core.target.LazyTarget;
import io.qameta.atlas.core.util.MethodInfo;
import io.qameta.atlas.webdriver.extension.FindBy;
import io.qameta.atlas.webdriver.extension.Name;
import io.qameta.atlas.webdriver.util.MethodInfoUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class FindByExtension
implements MethodExtension {
    public boolean test(Method method) {
        return method.isAnnotationPresent(FindBy.class) && WebElement.class.isAssignableFrom(method.getReturnType());
    }

    public Object invoke(Object proxy, MethodInfo methodInfo, Configuration configuration) {
        Method method = methodInfo.getMethod();
        assert (proxy instanceof SearchContext);
        assert (method.isAnnotationPresent(FindBy.class));
        Map<String, String> parameters = MethodInfoUtils.getParamValues(method, methodInfo.getArgs());
        FindBy findBy = method.getAnnotation(FindBy.class);
        By by = findBy.selector().buildBy(MethodInfoUtils.processParamTemplate(findBy.value(), parameters));
        SearchContext searchContext = (SearchContext)proxy;
        String name = Optional.ofNullable(method.getAnnotation(Name.class)).map(Name::value).map(template -> MethodInfoUtils.processParamTemplate(template, parameters)).orElse(method.getName());
        Configuration childConfiguration = configuration.child();
        Optional.ofNullable(methodInfo.getMethod().getAnnotation(Retry.class)).ifPresent(retry -> {
            DefaultRetryer retryer = new DefaultRetryer(retry);
            childConfiguration.registerContext((Context)new RetryerContext((Retryer)retryer));
        });
        LazyTarget elementTarget = new LazyTarget(name, () -> searchContext.findElement(by));
        return new Atlas(childConfiguration).create((Target)elementTarget, method.getReturnType());
    }
}

