/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.atlas.webdriver.extension;

import io.qameta.atlas.core.Atlas;
import io.qameta.atlas.core.AtlasException;
import io.qameta.atlas.core.api.MethodExtension;
import io.qameta.atlas.core.internal.Configuration;
import io.qameta.atlas.core.util.MethodInfo;
import io.qameta.atlas.core.util.ReflectionUtils;
import io.qameta.atlas.webdriver.extension.Page;
import io.qameta.atlas.webdriver.util.MethodInfoUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.client.utils.URIBuilder;
import org.openqa.selenium.WrapsDriver;

public class PageExtension
implements MethodExtension {
    private static final String DEFAULT_PATH = "/";

    public boolean test(Method method) {
        return ReflectionUtils.isAnnotated((AnnotatedElement)method, Page.class);
    }

    public Object invoke(Object proxy, MethodInfo methodInfo, Configuration configuration) {
        assert (proxy instanceof WrapsDriver);
        Method method = methodInfo.getMethod();
        Object[] args = methodInfo.getArgs();
        String baseURL = method.getAnnotation(Page.class).url();
        WrapsDriver wrapsDriver = (WrapsDriver)proxy;
        String baseURI = Optional.ofNullable(System.getProperties().getProperty("ATLAS_WEBSITE_URL")).orElseThrow(() -> new AtlasException("URI WebSite did'nt declared."));
        Map<String, String> pathParameters = MethodInfoUtils.getPathSegmentValues(method, args);
        String pathSegment = MethodInfoUtils.processTemplate(baseURL, pathParameters, "{", "}");
        Map<String, String> queryParameters = Stream.of(MethodInfoUtils.getQueryValues(method, args), MethodInfoUtils.getQueryMapValues(method, args)).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String requestURL = this.buildUrl(baseURI, pathSegment, queryParameters);
        Optional.of(requestURL).filter(it -> !it.equals(baseURI + DEFAULT_PATH)).ifPresent(url -> wrapsDriver.getWrappedDriver().get(requestURL));
        return new Atlas(configuration).create((Object)wrapsDriver.getWrappedDriver(), method.getReturnType());
    }

    private String buildUrl(String baseURI, String pathSegment, Map<String, String> queryParameters) {
        URIBuilder urlBuilder;
        try {
            urlBuilder = new URIBuilder(baseURI);
            urlBuilder.setPath(pathSegment);
            queryParameters.forEach((arg_0, arg_1) -> ((URIBuilder)urlBuilder).addParameter(arg_0, arg_1));
        }
        catch (URISyntaxException e) {
            throw new AtlasException("Can't parse base URL of your WebSite", (Exception)e);
        }
        return urlBuilder.toString();
    }
}

