/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.atlas.webdriver.extension;

import io.qameta.atlas.core.api.MethodExtension;
import io.qameta.atlas.core.internal.Configuration;
import io.qameta.atlas.core.util.MethodInfo;
import io.qameta.atlas.webdriver.exception.WaitUntilException;
import java.lang.reflect.Method;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public class WaitUntilMethodExtension
implements MethodExtension {
    private static final String WAIT_UNTIL = "waitUntil";

    public boolean test(Method method) {
        return WAIT_UNTIL.equals(method.getName());
    }

    public Object invoke(Object proxy, MethodInfo methodInfo, Configuration configuration) {
        String message = methodInfo.getParameter(String.class).orElse("");
        Matcher matcher = (Matcher)methodInfo.getParameter(Matcher.class).orElseThrow(() -> new IllegalStateException("Unexpected method signature"));
        if (!matcher.matches(proxy)) {
            StringDescription description = new StringDescription();
            description.appendText(message).appendText("\nExpected: ").appendDescriptionOf((SelfDescribing)matcher).appendText("\n     but: ");
            matcher.describeMismatch(proxy, (Description)description);
            throw new WaitUntilException(description.toString());
        }
        return proxy;
    }
}

