/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.atlas.webdriver.util;

import io.qameta.atlas.core.util.ReflectionUtils;
import io.qameta.atlas.webdriver.extension.Param;
import io.qameta.atlas.webdriver.extension.Path;
import io.qameta.atlas.webdriver.extension.Query;
import io.qameta.atlas.webdriver.extension.QueryMap;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class MethodInfoUtils {
    private MethodInfoUtils() {
    }

    public static String processParamTemplate(String template, Map<String, String> parameters) {
        return MethodInfoUtils.processTemplate(template, parameters, "{{ ", " }}");
    }

    public static String processTemplate(String template, Map<String, String> parameters, CharSequence prefix, CharSequence suffix) {
        return parameters.entrySet().stream().reduce(template, (a, b) -> a.replace(prefix + (String)b.getKey() + suffix, (CharSequence)b.getValue()), (s, s2) -> s);
    }

    public static Map<String, String> getQueryMapValues(Method method, Object[] args) {
        IntPredicate queryPredicate = index -> ReflectionUtils.isAnnotated((AnnotatedElement)method.getParameters()[index], QueryMap.class);
        return IntStream.range(0, method.getParameterCount()).filter(queryPredicate).boxed().map(index -> (HashMap)args[index]).flatMap(x -> x.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> getQueryValues(Method method, Object[] args) {
        IntPredicate queryPredicate = index -> ReflectionUtils.isAnnotated((AnnotatedElement)method.getParameters()[index], Query.class);
        return MethodInfoUtils.getParameters(queryPredicate, method, Collectors.toMap(index -> MethodInfoUtils.getQueryValue(method.getParameters()[index]), index -> Objects.toString(args[index])));
    }

    public static Map<String, String> getPathSegmentValues(Method method, Object[] args) {
        IntPredicate pathSegmentPredicate = index -> ReflectionUtils.isAnnotated((AnnotatedElement)method.getParameters()[index], Path.class);
        return MethodInfoUtils.getParameters(pathSegmentPredicate, method, Collectors.toMap(index -> MethodInfoUtils.getPathValue(method.getParameters()[index]), index -> Objects.toString(args[index])));
    }

    public static Map<String, String> getParamValues(Method method, Object[] args) {
        IntPredicate paramPredicate = index -> ReflectionUtils.isAnnotated((AnnotatedElement)method.getParameters()[index], Param.class);
        return MethodInfoUtils.getParameters(paramPredicate, method, Collectors.toMap(index -> MethodInfoUtils.getParamValue(method.getParameters()[index]), index -> Objects.toString(args[index])));
    }

    private static Map<String, String> getParameters(IntPredicate predicate, Method method, Collector<Integer, ?, Map<String, String>> collector) {
        return IntStream.range(0, method.getParameterCount()).filter(predicate).boxed().collect(collector);
    }

    private static String getParamValue(AnnotatedElement element) {
        return element.getAnnotation(Param.class).value();
    }

    private static String getQueryValue(AnnotatedElement element) {
        return element.getAnnotation(Query.class).value();
    }

    private static String getPathValue(AnnotatedElement element) {
        return element.getAnnotation(Path.class).value();
    }
}

