/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.v1.api;

import com.google.gson.reflect.TypeToken;
import io.qase.client.v1.ApiCallback;
import io.qase.client.v1.ApiClient;
import io.qase.client.v1.ApiException;
import io.qase.client.v1.ApiResponse;
import io.qase.client.v1.Configuration;
import io.qase.client.v1.Pair;
import io.qase.client.v1.models.ConfigurationCreate;
import io.qase.client.v1.models.ConfigurationGroupCreate;
import io.qase.client.v1.models.ConfigurationListResponse;
import io.qase.client.v1.models.IdResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ConfigurationsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ConfigurationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConfigurationsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createConfigurationCall(String code, ConfigurationCreate configurationCreate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ConfigurationCreate localVarPostBody = configurationCreate;
        String localVarPath = "/configuration/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createConfigurationValidateBeforeCall(String code, ConfigurationCreate configurationCreate, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling createConfiguration(Async)");
        }
        if (configurationCreate == null) {
            throw new ApiException("Missing the required parameter 'configurationCreate' when calling createConfiguration(Async)");
        }
        return this.createConfigurationCall(code, configurationCreate, _callback);
    }

    public IdResponse createConfiguration(String code, ConfigurationCreate configurationCreate) throws ApiException {
        ApiResponse<IdResponse> localVarResp = this.createConfigurationWithHttpInfo(code, configurationCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> createConfigurationWithHttpInfo(String code, ConfigurationCreate configurationCreate) throws ApiException {
        Call localVarCall = this.createConfigurationValidateBeforeCall(code, configurationCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createConfigurationAsync(String code, ConfigurationCreate configurationCreate, ApiCallback<IdResponse> _callback) throws ApiException {
        Call localVarCall = this.createConfigurationValidateBeforeCall(code, configurationCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createConfigurationGroupCall(String code, ConfigurationGroupCreate configurationGroupCreate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ConfigurationGroupCreate localVarPostBody = configurationGroupCreate;
        String localVarPath = "/configuration/{code}/group".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createConfigurationGroupValidateBeforeCall(String code, ConfigurationGroupCreate configurationGroupCreate, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling createConfigurationGroup(Async)");
        }
        if (configurationGroupCreate == null) {
            throw new ApiException("Missing the required parameter 'configurationGroupCreate' when calling createConfigurationGroup(Async)");
        }
        return this.createConfigurationGroupCall(code, configurationGroupCreate, _callback);
    }

    public IdResponse createConfigurationGroup(String code, ConfigurationGroupCreate configurationGroupCreate) throws ApiException {
        ApiResponse<IdResponse> localVarResp = this.createConfigurationGroupWithHttpInfo(code, configurationGroupCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> createConfigurationGroupWithHttpInfo(String code, ConfigurationGroupCreate configurationGroupCreate) throws ApiException {
        Call localVarCall = this.createConfigurationGroupValidateBeforeCall(code, configurationGroupCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createConfigurationGroupAsync(String code, ConfigurationGroupCreate configurationGroupCreate, ApiCallback<IdResponse> _callback) throws ApiException {
        Call localVarCall = this.createConfigurationGroupValidateBeforeCall(code, configurationGroupCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getConfigurationsCall(String code, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/configuration/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getConfigurationsValidateBeforeCall(String code, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling getConfigurations(Async)");
        }
        return this.getConfigurationsCall(code, _callback);
    }

    public ConfigurationListResponse getConfigurations(String code) throws ApiException {
        ApiResponse<ConfigurationListResponse> localVarResp = this.getConfigurationsWithHttpInfo(code);
        return localVarResp.getData();
    }

    public ApiResponse<ConfigurationListResponse> getConfigurationsWithHttpInfo(String code) throws ApiException {
        Call localVarCall = this.getConfigurationsValidateBeforeCall(code, null);
        Type localVarReturnType = new TypeToken<ConfigurationListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getConfigurationsAsync(String code, ApiCallback<ConfigurationListResponse> _callback) throws ApiException {
        Call localVarCall = this.getConfigurationsValidateBeforeCall(code, _callback);
        Type localVarReturnType = new TypeToken<ConfigurationListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

