/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.v1.api;

import com.google.gson.reflect.TypeToken;
import io.qase.client.v1.ApiCallback;
import io.qase.client.v1.ApiClient;
import io.qase.client.v1.ApiException;
import io.qase.client.v1.ApiResponse;
import io.qase.client.v1.Configuration;
import io.qase.client.v1.Pair;
import io.qase.client.v1.models.BaseResponse;
import io.qase.client.v1.models.ProjectAccess;
import io.qase.client.v1.models.ProjectCodeResponse;
import io.qase.client.v1.models.ProjectCreate;
import io.qase.client.v1.models.ProjectListResponse;
import io.qase.client.v1.models.ProjectResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ProjectsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createProjectCall(ProjectCreate projectCreate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProjectCreate localVarPostBody = projectCreate;
        String localVarPath = "/project";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProjectValidateBeforeCall(ProjectCreate projectCreate, ApiCallback _callback) throws ApiException {
        if (projectCreate == null) {
            throw new ApiException("Missing the required parameter 'projectCreate' when calling createProject(Async)");
        }
        return this.createProjectCall(projectCreate, _callback);
    }

    public ProjectCodeResponse createProject(ProjectCreate projectCreate) throws ApiException {
        ApiResponse<ProjectCodeResponse> localVarResp = this.createProjectWithHttpInfo(projectCreate);
        return localVarResp.getData();
    }

    public ApiResponse<ProjectCodeResponse> createProjectWithHttpInfo(ProjectCreate projectCreate) throws ApiException {
        Call localVarCall = this.createProjectValidateBeforeCall(projectCreate, null);
        Type localVarReturnType = new TypeToken<ProjectCodeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProjectAsync(ProjectCreate projectCreate, ApiCallback<ProjectCodeResponse> _callback) throws ApiException {
        Call localVarCall = this.createProjectValidateBeforeCall(projectCreate, _callback);
        Type localVarReturnType = new TypeToken<ProjectCodeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProjectCall(String code, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/project/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProjectValidateBeforeCall(String code, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling deleteProject(Async)");
        }
        return this.deleteProjectCall(code, _callback);
    }

    public BaseResponse deleteProject(String code) throws ApiException {
        ApiResponse<BaseResponse> localVarResp = this.deleteProjectWithHttpInfo(code);
        return localVarResp.getData();
    }

    public ApiResponse<BaseResponse> deleteProjectWithHttpInfo(String code) throws ApiException {
        Call localVarCall = this.deleteProjectValidateBeforeCall(code, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteProjectAsync(String code, ApiCallback<BaseResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteProjectValidateBeforeCall(code, _callback);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProjectCall(String code, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/project/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectValidateBeforeCall(String code, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling getProject(Async)");
        }
        return this.getProjectCall(code, _callback);
    }

    public ProjectResponse getProject(String code) throws ApiException {
        ApiResponse<ProjectResponse> localVarResp = this.getProjectWithHttpInfo(code);
        return localVarResp.getData();
    }

    public ApiResponse<ProjectResponse> getProjectWithHttpInfo(String code) throws ApiException {
        Call localVarCall = this.getProjectValidateBeforeCall(code, null);
        Type localVarReturnType = new TypeToken<ProjectResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectAsync(String code, ApiCallback<ProjectResponse> _callback) throws ApiException {
        Call localVarCall = this.getProjectValidateBeforeCall(code, _callback);
        Type localVarReturnType = new TypeToken<ProjectResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProjectsCall(Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/project";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectsValidateBeforeCall(Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        return this.getProjectsCall(limit, offset, _callback);
    }

    public ProjectListResponse getProjects(Integer limit, Integer offset) throws ApiException {
        ApiResponse<ProjectListResponse> localVarResp = this.getProjectsWithHttpInfo(limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ProjectListResponse> getProjectsWithHttpInfo(Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.getProjectsValidateBeforeCall(limit, offset, null);
        Type localVarReturnType = new TypeToken<ProjectListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectsAsync(Integer limit, Integer offset, ApiCallback<ProjectListResponse> _callback) throws ApiException {
        Call localVarCall = this.getProjectsValidateBeforeCall(limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ProjectListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call grantAccessToProjectCall(String code, ProjectAccess projectAccess, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProjectAccess localVarPostBody = projectAccess;
        String localVarPath = "/project/{code}/access".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call grantAccessToProjectValidateBeforeCall(String code, ProjectAccess projectAccess, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling grantAccessToProject(Async)");
        }
        if (projectAccess == null) {
            throw new ApiException("Missing the required parameter 'projectAccess' when calling grantAccessToProject(Async)");
        }
        return this.grantAccessToProjectCall(code, projectAccess, _callback);
    }

    public BaseResponse grantAccessToProject(String code, ProjectAccess projectAccess) throws ApiException {
        ApiResponse<BaseResponse> localVarResp = this.grantAccessToProjectWithHttpInfo(code, projectAccess);
        return localVarResp.getData();
    }

    public ApiResponse<BaseResponse> grantAccessToProjectWithHttpInfo(String code, ProjectAccess projectAccess) throws ApiException {
        Call localVarCall = this.grantAccessToProjectValidateBeforeCall(code, projectAccess, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call grantAccessToProjectAsync(String code, ProjectAccess projectAccess, ApiCallback<BaseResponse> _callback) throws ApiException {
        Call localVarCall = this.grantAccessToProjectValidateBeforeCall(code, projectAccess, _callback);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call revokeAccessToProjectCall(String code, ProjectAccess projectAccess, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProjectAccess localVarPostBody = projectAccess;
        String localVarPath = "/project/{code}/access".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revokeAccessToProjectValidateBeforeCall(String code, ProjectAccess projectAccess, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling revokeAccessToProject(Async)");
        }
        if (projectAccess == null) {
            throw new ApiException("Missing the required parameter 'projectAccess' when calling revokeAccessToProject(Async)");
        }
        return this.revokeAccessToProjectCall(code, projectAccess, _callback);
    }

    public BaseResponse revokeAccessToProject(String code, ProjectAccess projectAccess) throws ApiException {
        ApiResponse<BaseResponse> localVarResp = this.revokeAccessToProjectWithHttpInfo(code, projectAccess);
        return localVarResp.getData();
    }

    public ApiResponse<BaseResponse> revokeAccessToProjectWithHttpInfo(String code, ProjectAccess projectAccess) throws ApiException {
        Call localVarCall = this.revokeAccessToProjectValidateBeforeCall(code, projectAccess, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call revokeAccessToProjectAsync(String code, ProjectAccess projectAccess, ApiCallback<BaseResponse> _callback) throws ApiException {
        Call localVarCall = this.revokeAccessToProjectValidateBeforeCall(code, projectAccess, _callback);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

