/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.v1.api;

import com.google.gson.reflect.TypeToken;
import io.qase.client.v1.ApiCallback;
import io.qase.client.v1.ApiClient;
import io.qase.client.v1.ApiException;
import io.qase.client.v1.ApiResponse;
import io.qase.client.v1.Configuration;
import io.qase.client.v1.Pair;
import io.qase.client.v1.models.IdResponse;
import io.qase.client.v1.models.SuiteCreate;
import io.qase.client.v1.models.SuiteDelete;
import io.qase.client.v1.models.SuiteListResponse;
import io.qase.client.v1.models.SuiteResponse;
import io.qase.client.v1.models.SuiteUpdate;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SuitesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SuitesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SuitesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSuiteCall(String code, SuiteCreate suiteCreate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SuiteCreate localVarPostBody = suiteCreate;
        String localVarPath = "/suite/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSuiteValidateBeforeCall(String code, SuiteCreate suiteCreate, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling createSuite(Async)");
        }
        if (suiteCreate == null) {
            throw new ApiException("Missing the required parameter 'suiteCreate' when calling createSuite(Async)");
        }
        return this.createSuiteCall(code, suiteCreate, _callback);
    }

    public IdResponse createSuite(String code, SuiteCreate suiteCreate) throws ApiException {
        ApiResponse<IdResponse> localVarResp = this.createSuiteWithHttpInfo(code, suiteCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> createSuiteWithHttpInfo(String code, SuiteCreate suiteCreate) throws ApiException {
        Call localVarCall = this.createSuiteValidateBeforeCall(code, suiteCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSuiteAsync(String code, SuiteCreate suiteCreate, ApiCallback<IdResponse> _callback) throws ApiException {
        Call localVarCall = this.createSuiteValidateBeforeCall(code, suiteCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSuiteCall(String code, Integer id, SuiteDelete suiteDelete, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SuiteDelete localVarPostBody = suiteDelete;
        String localVarPath = "/suite/{code}/{id}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSuiteValidateBeforeCall(String code, Integer id, SuiteDelete suiteDelete, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling deleteSuite(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteSuite(Async)");
        }
        return this.deleteSuiteCall(code, id, suiteDelete, _callback);
    }

    public IdResponse deleteSuite(String code, Integer id, SuiteDelete suiteDelete) throws ApiException {
        ApiResponse<IdResponse> localVarResp = this.deleteSuiteWithHttpInfo(code, id, suiteDelete);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> deleteSuiteWithHttpInfo(String code, Integer id, SuiteDelete suiteDelete) throws ApiException {
        Call localVarCall = this.deleteSuiteValidateBeforeCall(code, id, suiteDelete, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSuiteAsync(String code, Integer id, SuiteDelete suiteDelete, ApiCallback<IdResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteSuiteValidateBeforeCall(code, id, suiteDelete, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSuiteCall(String code, Integer id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/suite/{code}/{id}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSuiteValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling getSuite(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSuite(Async)");
        }
        return this.getSuiteCall(code, id, _callback);
    }

    public SuiteResponse getSuite(String code, Integer id) throws ApiException {
        ApiResponse<SuiteResponse> localVarResp = this.getSuiteWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<SuiteResponse> getSuiteWithHttpInfo(String code, Integer id) throws ApiException {
        Call localVarCall = this.getSuiteValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<SuiteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSuiteAsync(String code, Integer id, ApiCallback<SuiteResponse> _callback) throws ApiException {
        Call localVarCall = this.getSuiteValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<SuiteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSuitesCall(String code, String search, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/suite/{code}".replace("{code}", this.localVarApiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSuitesValidateBeforeCall(String code, String search, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling getSuites(Async)");
        }
        return this.getSuitesCall(code, search, limit, offset, _callback);
    }

    public SuiteListResponse getSuites(String code, String search, Integer limit, Integer offset) throws ApiException {
        ApiResponse<SuiteListResponse> localVarResp = this.getSuitesWithHttpInfo(code, search, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<SuiteListResponse> getSuitesWithHttpInfo(String code, String search, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.getSuitesValidateBeforeCall(code, search, limit, offset, null);
        Type localVarReturnType = new TypeToken<SuiteListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSuitesAsync(String code, String search, Integer limit, Integer offset, ApiCallback<SuiteListResponse> _callback) throws ApiException {
        Call localVarCall = this.getSuitesValidateBeforeCall(code, search, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<SuiteListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSuiteCall(String code, Integer id, SuiteUpdate suiteUpdate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SuiteUpdate localVarPostBody = suiteUpdate;
        String localVarPath = "/suite/{code}/{id}".replace("{code}", this.localVarApiClient.escapeString(code.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSuiteValidateBeforeCall(String code, Integer id, SuiteUpdate suiteUpdate, ApiCallback _callback) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling updateSuite(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSuite(Async)");
        }
        if (suiteUpdate == null) {
            throw new ApiException("Missing the required parameter 'suiteUpdate' when calling updateSuite(Async)");
        }
        return this.updateSuiteCall(code, id, suiteUpdate, _callback);
    }

    public IdResponse updateSuite(String code, Integer id, SuiteUpdate suiteUpdate) throws ApiException {
        ApiResponse<IdResponse> localVarResp = this.updateSuiteWithHttpInfo(code, id, suiteUpdate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> updateSuiteWithHttpInfo(String code, Integer id, SuiteUpdate suiteUpdate) throws ApiException {
        Call localVarCall = this.updateSuiteValidateBeforeCall(code, id, suiteUpdate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSuiteAsync(String code, Integer id, SuiteUpdate suiteUpdate, ApiCallback<IdResponse> _callback) throws ApiException {
        Call localVarCall = this.updateSuiteValidateBeforeCall(code, id, suiteUpdate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

