/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.v1.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.qase.client.v1.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProjectCreate {
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private String code;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ACCESS = "access";
    @SerializedName(value="access")
    private AccessEnum access;
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static final String SERIALIZED_NAME_SETTINGS = "settings";
    @SerializedName(value="settings")
    private Map<String, Object> settings = new HashMap<String, Object>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ProjectCreate title(String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ProjectCreate code(String code) {
        this.code = code;
        return this;
    }

    @Nonnull
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ProjectCreate description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProjectCreate access(AccessEnum access) {
        this.access = access;
        return this;
    }

    @Nullable
    public AccessEnum getAccess() {
        return this.access;
    }

    public void setAccess(AccessEnum access) {
        this.access = access;
    }

    public ProjectCreate group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public ProjectCreate settings(Map<String, Object> settings) {
        this.settings = settings;
        return this;
    }

    public ProjectCreate putSettingsItem(String key, Object settingsItem) {
        if (this.settings == null) {
            this.settings = new HashMap<String, Object>();
        }
        this.settings.put(key, settingsItem);
        return this;
    }

    @Nullable
    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, Object> settings) {
        this.settings = settings;
    }

    public ProjectCreate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectCreate projectCreate = (ProjectCreate)o;
        return Objects.equals(this.title, projectCreate.title) && Objects.equals(this.code, projectCreate.code) && Objects.equals(this.description, projectCreate.description) && Objects.equals((Object)this.access, (Object)projectCreate.access) && Objects.equals(this.group, projectCreate.group) && Objects.equals(this.settings, projectCreate.settings) && Objects.equals(this.additionalProperties, projectCreate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.code, this.description, this.access, this.group, this.settings, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectCreate {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    access: ").append(this.toIndentedString((Object)this.access)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ProjectCreate is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `access` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonNull()) {
            AccessEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP) != null && !jsonObj.get(SERIALIZED_NAME_GROUP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP).toString()));
        }
    }

    public static ProjectCreate fromJson(String jsonString) throws IOException {
        return (ProjectCreate)JSON.getGson().fromJson(jsonString, ProjectCreate.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_CODE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_GROUP);
        openapiFields.add(SERIALIZED_NAME_SETTINGS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TITLE);
        openapiRequiredFields.add(SERIALIZED_NAME_CODE);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AccessEnum {
        ALL("all"),
        GROUP("group"),
        NONE("none");

        private String value;

        private AccessEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccessEnum fromValue(String value) {
            for (AccessEnum b : AccessEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            AccessEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<AccessEnum> {
            public void write(JsonWriter jsonWriter, AccessEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AccessEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AccessEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ProjectCreate.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ProjectCreate.class));
            return new TypeAdapter<ProjectCreate>(){

                public void write(JsonWriter out, ProjectCreate value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ProjectCreate read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ProjectCreate.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    ProjectCreate instance = (ProjectCreate)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

