/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.v1.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.qase.client.v1.JSON;
import io.qase.client.v1.models.AbstractOpenApiSchema;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QqlTestCaseParams
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(QqlTestCaseParams.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public QqlTestCaseParams() {
        super("anyOf", Boolean.FALSE);
    }

    public QqlTestCaseParams(List<Object> o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public QqlTestCaseParams(Object o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        List list;
        if (instance instanceof List && (list = (List)instance).get(0) instanceof Object) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof Object) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be List<Object>, Object");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public List<Object> getList() throws ClassCastException {
        return (List)super.getActualInstance();
    }

    public Object getObject() throws ClassCastException {
        return super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                throw new IllegalArgumentException(String.format("Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
            }
            if (!jsonElement.isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected json element to be a array type in the JSON string but got `%s`", jsonElement.toString()));
            }
            JsonArray array = jsonElement.getAsJsonArray();
            for (JsonElement element : array) {
                if (element.getAsJsonPrimitive().isNumber()) continue;
                throw new IllegalArgumentException(String.format("Expected array items to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
            }
            return;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for List<Object> failed with `%s`.", e.getMessage()));
            try {
                if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                    throw new IllegalArgumentException(String.format("Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
                }
                return;
            }
            catch (Exception e2) {
                errorMessages.add(String.format("Deserialization for Object failed with `%s`.", e2.getMessage()));
                throw new IOException(String.format("The JSON string is invalid for QqlTestCaseParams with anyOf schemas: List<Object>, Object. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
            }
        }
    }

    public static QqlTestCaseParams fromJson(String jsonString) throws IOException {
        return (QqlTestCaseParams)JSON.getGson().fromJson(jsonString, QqlTestCaseParams.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("List<Object>", List.class);
        schemas.put("Object", Object.class);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!QqlTestCaseParams.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            Type typeInstance = new TypeToken<List<Object>>(){}.getType();
            final TypeAdapter adapterList = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get((Type)typeInstance));
            final TypeAdapter adapterObject = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Object.class));
            return new TypeAdapter<QqlTestCaseParams>(){

                public void write(JsonWriter out, QqlTestCaseParams value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof List) {
                        JsonPrimitive primitive = adapterList.toJsonTree((Object)((List)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    if (value.getActualInstance() instanceof Object) {
                        JsonPrimitive primitive = adapterObject.toJsonTree(value.getActualInstance()).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemae: List<Object>, Object");
                }

                public QqlTestCaseParams read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                            throw new IllegalArgumentException(String.format("Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterList;
                        if (!jsonElement.isJsonArray()) {
                            throw new IllegalArgumentException(String.format("Expected json element to be a array type in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        JsonArray array = jsonElement.getAsJsonArray();
                        for (JsonElement element : array) {
                            if (element.getAsJsonPrimitive().isNumber()) continue;
                            throw new IllegalArgumentException(String.format("Expected array items to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterList;
                        QqlTestCaseParams ret = new QqlTestCaseParams();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for List<Object> failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'List<Object>'", e);
                        try {
                            if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                                throw new IllegalArgumentException(String.format("Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
                            }
                            actualAdapter = adapterObject;
                            QqlTestCaseParams ret = new QqlTestCaseParams();
                            ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                            return ret;
                        }
                        catch (Exception e2) {
                            errorMessages.add(String.format("Deserialization for Object failed with `%s`.", e2.getMessage()));
                            log.log(Level.FINER, "Input data does not match schema 'Object'", e2);
                            throw new IOException(String.format("Failed deserialization for QqlTestCaseParams: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

