/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.v1.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.qase.client.v1.JSON;
import io.qase.client.v1.models.CustomFieldValue;
import io.qase.client.v1.models.RunEnvironment;
import io.qase.client.v1.models.RunExternalIssue;
import io.qase.client.v1.models.RunMilestone;
import io.qase.client.v1.models.RunStats;
import io.qase.client.v1.models.TagValue;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class Run {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Long id;
    public static final String SERIALIZED_NAME_RUN_ID = "run_id";
    @SerializedName(value="run_id")
    private Long runId;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private Integer status;
    public static final String SERIALIZED_NAME_STATUS_TEXT = "status_text";
    @SerializedName(value="status_text")
    private String statusText;
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_END_TIME = "end_time";
    @SerializedName(value="end_time")
    private OffsetDateTime endTime;
    public static final String SERIALIZED_NAME_PUBLIC = "public";
    @SerializedName(value="public")
    private Boolean _public;
    public static final String SERIALIZED_NAME_STATS = "stats";
    @SerializedName(value="stats")
    private RunStats stats;
    public static final String SERIALIZED_NAME_TIME_SPENT = "time_spent";
    @SerializedName(value="time_spent")
    private Long timeSpent;
    public static final String SERIALIZED_NAME_ELAPSED_TIME = "elapsed_time";
    @SerializedName(value="elapsed_time")
    private Long elapsedTime;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private RunEnvironment environment;
    public static final String SERIALIZED_NAME_MILESTONE = "milestone";
    @SerializedName(value="milestone")
    private RunMilestone milestone;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    private List<CustomFieldValue> customFields;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<TagValue> tags;
    public static final String SERIALIZED_NAME_CASES = "cases";
    @SerializedName(value="cases")
    private List<Long> cases;
    public static final String SERIALIZED_NAME_PLAN_ID = "plan_id";
    @SerializedName(value="plan_id")
    private Long planId;
    public static final String SERIALIZED_NAME_CONFIGURATIONS = "configurations";
    @SerializedName(value="configurations")
    private List<Long> configurations;
    public static final String SERIALIZED_NAME_EXTERNAL_ISSUE = "external_issue";
    @SerializedName(value="external_issue")
    private RunExternalIssue externalIssue;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Run id(Long id) {
        this.id = id;
        return this;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Run runId(Long runId) {
        this.runId = runId;
        return this;
    }

    @Nullable
    public Long getRunId() {
        return this.runId;
    }

    public void setRunId(Long runId) {
        this.runId = runId;
    }

    public Run title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Run description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Run status(Integer status) {
        this.status = status;
        return this;
    }

    @Nullable
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Run statusText(String statusText) {
        this.statusText = statusText;
        return this;
    }

    @Nullable
    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public Run startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public Run endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public Run _public(Boolean _public) {
        this._public = _public;
        return this;
    }

    @Nullable
    public Boolean getPublic() {
        return this._public;
    }

    public void setPublic(Boolean _public) {
        this._public = _public;
    }

    public Run stats(RunStats stats) {
        this.stats = stats;
        return this;
    }

    @Nullable
    public RunStats getStats() {
        return this.stats;
    }

    public void setStats(RunStats stats) {
        this.stats = stats;
    }

    public Run timeSpent(Long timeSpent) {
        this.timeSpent = timeSpent;
        return this;
    }

    @Nullable
    public Long getTimeSpent() {
        return this.timeSpent;
    }

    public void setTimeSpent(Long timeSpent) {
        this.timeSpent = timeSpent;
    }

    public Run elapsedTime(Long elapsedTime) {
        this.elapsedTime = elapsedTime;
        return this;
    }

    @Nullable
    public Long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(Long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public Run environment(RunEnvironment environment) {
        this.environment = environment;
        return this;
    }

    @Nullable
    public RunEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(RunEnvironment environment) {
        this.environment = environment;
    }

    public Run milestone(RunMilestone milestone) {
        this.milestone = milestone;
        return this;
    }

    @Nullable
    public RunMilestone getMilestone() {
        return this.milestone;
    }

    public void setMilestone(RunMilestone milestone) {
        this.milestone = milestone;
    }

    public Run customFields(List<CustomFieldValue> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Run addCustomFieldsItem(CustomFieldValue customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new ArrayList<CustomFieldValue>();
        }
        this.customFields.add(customFieldsItem);
        return this;
    }

    @Nullable
    public List<CustomFieldValue> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(List<CustomFieldValue> customFields) {
        this.customFields = customFields;
    }

    public Run tags(List<TagValue> tags) {
        this.tags = tags;
        return this;
    }

    public Run addTagsItem(TagValue tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagValue>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    public List<TagValue> getTags() {
        return this.tags;
    }

    public void setTags(List<TagValue> tags) {
        this.tags = tags;
    }

    public Run cases(List<Long> cases) {
        this.cases = cases;
        return this;
    }

    public Run addCasesItem(Long casesItem) {
        if (this.cases == null) {
            this.cases = new ArrayList<Long>();
        }
        this.cases.add(casesItem);
        return this;
    }

    @Nullable
    public List<Long> getCases() {
        return this.cases;
    }

    public void setCases(List<Long> cases) {
        this.cases = cases;
    }

    public Run planId(Long planId) {
        this.planId = planId;
        return this;
    }

    @Nullable
    public Long getPlanId() {
        return this.planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Run configurations(List<Long> configurations) {
        this.configurations = configurations;
        return this;
    }

    public Run addConfigurationsItem(Long configurationsItem) {
        if (this.configurations == null) {
            this.configurations = new ArrayList<Long>();
        }
        this.configurations.add(configurationsItem);
        return this;
    }

    @Nullable
    public List<Long> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<Long> configurations) {
        this.configurations = configurations;
    }

    public Run externalIssue(RunExternalIssue externalIssue) {
        this.externalIssue = externalIssue;
        return this;
    }

    @Nullable
    public RunExternalIssue getExternalIssue() {
        return this.externalIssue;
    }

    public void setExternalIssue(RunExternalIssue externalIssue) {
        this.externalIssue = externalIssue;
    }

    public Run putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Run run = (Run)o;
        return Objects.equals(this.id, run.id) && Objects.equals(this.runId, run.runId) && Objects.equals(this.title, run.title) && Objects.equals(this.description, run.description) && Objects.equals(this.status, run.status) && Objects.equals(this.statusText, run.statusText) && Objects.equals(this.startTime, run.startTime) && Objects.equals(this.endTime, run.endTime) && Objects.equals(this._public, run._public) && Objects.equals(this.stats, run.stats) && Objects.equals(this.timeSpent, run.timeSpent) && Objects.equals(this.elapsedTime, run.elapsedTime) && Objects.equals(this.environment, run.environment) && Objects.equals(this.milestone, run.milestone) && Objects.equals(this.customFields, run.customFields) && Objects.equals(this.tags, run.tags) && Objects.equals(this.cases, run.cases) && Objects.equals(this.planId, run.planId) && Objects.equals(this.configurations, run.configurations) && Objects.equals(this.externalIssue, run.externalIssue) && Objects.equals(this.additionalProperties, run.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.runId, this.title, this.description, this.status, this.statusText, this.startTime, this.endTime, this._public, this.stats, this.timeSpent, this.elapsedTime, this.environment, this.milestone, this.customFields, this.tags, this.cases, this.planId, this.configurations, this.externalIssue, this.additionalProperties);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Run {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    runId: ").append(this.toIndentedString(this.runId)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    statusText: ").append(this.toIndentedString(this.statusText)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    _public: ").append(this.toIndentedString(this._public)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("    timeSpent: ").append(this.toIndentedString(this.timeSpent)).append("\n");
        sb.append("    elapsedTime: ").append(this.toIndentedString(this.elapsedTime)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    milestone: ").append(this.toIndentedString(this.milestone)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    cases: ").append(this.toIndentedString(this.cases)).append("\n");
        sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        sb.append("    configurations: ").append(this.toIndentedString(this.configurations)).append("\n");
        sb.append("    externalIssue: ").append(this.toIndentedString(this.externalIssue)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraytags;
        int i;
        JsonArray jsonArraycustomFields;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Run is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_STATUS_TEXT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS_TEXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATS) != null && !jsonObj.get(SERIALIZED_NAME_STATS).isJsonNull()) {
            RunStats.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT).isJsonNull()) {
            RunEnvironment.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ENVIRONMENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_MILESTONE) != null && !jsonObj.get(SERIALIZED_NAME_MILESTONE).isJsonNull()) {
            RunMilestone.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MILESTONE));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOM_FIELDS) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOM_FIELDS).isJsonNull() && (jsonArraycustomFields = jsonObj.getAsJsonArray(SERIALIZED_NAME_CUSTOM_FIELDS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CUSTOM_FIELDS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `custom_fields` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOM_FIELDS).toString()));
            }
            for (i = 0; i < jsonArraycustomFields.size(); ++i) {
                CustomFieldValue.validateJsonElement(jsonArraycustomFields.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonNull() && (jsonArraytags = jsonObj.getAsJsonArray(SERIALIZED_NAME_TAGS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
            }
            for (i = 0; i < jsonArraytags.size(); ++i) {
                TagValue.validateJsonElement(jsonArraytags.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CASES) != null && !jsonObj.get(SERIALIZED_NAME_CASES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CASES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cases` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CASES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIGURATIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONFIGURATIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONFIGURATIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `configurations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIGURATIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_ISSUE) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_ISSUE).isJsonNull()) {
            RunExternalIssue.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXTERNAL_ISSUE));
        }
    }

    public static Run fromJson(String jsonString) throws IOException {
        return (Run)JSON.getGson().fromJson(jsonString, Run.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_RUN_ID);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_STATUS_TEXT);
        openapiFields.add(SERIALIZED_NAME_START_TIME);
        openapiFields.add(SERIALIZED_NAME_END_TIME);
        openapiFields.add(SERIALIZED_NAME_PUBLIC);
        openapiFields.add(SERIALIZED_NAME_STATS);
        openapiFields.add(SERIALIZED_NAME_TIME_SPENT);
        openapiFields.add(SERIALIZED_NAME_ELAPSED_TIME);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT);
        openapiFields.add(SERIALIZED_NAME_MILESTONE);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_FIELDS);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_CASES);
        openapiFields.add(SERIALIZED_NAME_PLAN_ID);
        openapiFields.add(SERIALIZED_NAME_CONFIGURATIONS);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_ISSUE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Run.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Run.class));
            return new TypeAdapter<Run>(){

                public void write(JsonWriter out, Run value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Run read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Run.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    Run instance = (Run)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

