/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.v1.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.qase.client.v1.JSON;
import io.qase.client.v1.models.AbstractOpenApiSchema;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestCaseParams
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(TestCaseParams.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public TestCaseParams() {
        super("anyOf", Boolean.FALSE);
    }

    public TestCaseParams(Object o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        List list;
        if (instance instanceof List && (list = (List)instance).get(0) instanceof Object) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof Map) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be List<Object>, Map<String, List<String>>");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public Map<String, List<String>> getMapStringListString() throws ClassCastException {
        return (Map)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            if (!jsonElement.isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected json element to be a array type in the JSON string but got `%s`", jsonElement.toString()));
            }
            JsonArray array = jsonElement.getAsJsonArray();
            for (JsonElement element : array) {
                if (element.getAsJsonPrimitive().isNumber()) continue;
                throw new IllegalArgumentException(String.format("Expected array items to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
            }
            return;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for List<Object> failed with `%s`.", e.getMessage()));
            try {
                if (!jsonElement.isJsonObject()) {
                    throw new IllegalArgumentException(String.format("Expected json element to be an object type in the JSON string but got `%s`", jsonElement.toString()));
                }
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    JsonElement value = (JsonElement)entry.getValue();
                    if (!value.isJsonArray()) {
                        throw new IllegalArgumentException(String.format("Expected object values to be arrays in the JSON string but got `%s` for key `%s`", value.toString(), entry.getKey()));
                    }
                    JsonArray array = value.getAsJsonArray();
                    for (JsonElement element : array) {
                        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) continue;
                        throw new IllegalArgumentException(String.format("Expected array items to be of type String in the JSON string but got `%s`", element.toString()));
                    }
                }
                return;
            }
            catch (Exception e2) {
                errorMessages.add(String.format("Deserialization for Map<String, List<String>> failed with `%s`.", e2.getMessage()));
                throw new IOException(String.format("The JSON string is invalid for TestCaseParams with anyOf schemas: List<Object>, Map<String, List<String>>. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
            }
        }
    }

    public static TestCaseParams fromJson(String jsonString) throws IOException {
        return (TestCaseParams)JSON.getGson().fromJson(jsonString, TestCaseParams.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("List<Object>", List.class);
        schemas.put("Map<String, List<String>>", Map.class);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TestCaseParams.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            Type typeInstanceListObject = new TypeToken<List<Object>>(){}.getType();
            final TypeAdapter adapterListObject = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get((Type)typeInstanceListObject));
            Type typeInstanceMapStringListString = new TypeToken<Map<String, List<String>>>(){}.getType();
            final TypeAdapter adapterMap = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get((Type)typeInstanceMapStringListString));
            return new TypeAdapter<TestCaseParams>(){

                public void write(JsonWriter out, TestCaseParams value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof List) {
                        JsonPrimitive primitive = adapterListObject.toJsonTree((Object)((List)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    if (value.getActualInstance() instanceof Map) {
                        JsonElement element = adapterMap.toJsonTree((Object)((Map)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemas: List<Object>, Map<String, List<String>>");
                }

                public TestCaseParams read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        if (!jsonElement.isJsonArray()) {
                            throw new IllegalArgumentException(String.format("Expected json element to be a array type in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        JsonArray array = jsonElement.getAsJsonArray();
                        for (JsonElement element : array) {
                            if (element.getAsJsonPrimitive().isNumber()) continue;
                            throw new IllegalArgumentException(String.format("Expected array items to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterListObject;
                        TestCaseParams ret = new TestCaseParams();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for List<Object> failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'List<Object>'", e);
                        try {
                            TestCaseParams.validateJsonElement(jsonElement);
                            actualAdapter = adapterMap;
                            TestCaseParams ret = new TestCaseParams();
                            ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                            return ret;
                        }
                        catch (Exception e2) {
                            errorMessages.add(String.format("Deserialization for Map<String, List<String>> failed with `%s`.", e2.getMessage()));
                            log.log(Level.FINER, "Input data does not match schema 'Map<String, List<String>>'", e2);
                            throw new IOException(String.format("Failed deserialization for TestCaseParams: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

