/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.inner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import kong.unirest.GenericType;
import kong.unirest.ObjectMapper;

public final class GsonObjectMapper
implements ObjectMapper {
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final Gson gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (json, typeOfT, context) -> LocalDateTime.parse(json.getAsString(), FORMATTER)).registerTypeAdapter(LocalDateTime.class, (dateTime, typeOfSrc, context) -> new JsonPrimitive(FORMATTER.format((TemporalAccessor)dateTime))).setPrettyPrinting().create();

    public <T> T readValue(String value, Class<T> valueType) {
        return (T)this.gson.fromJson(value, valueType);
    }

    public <T> T readValue(String value, GenericType<T> genericType) {
        return (T)this.gson.fromJson(value, genericType.getType());
    }

    public String writeValue(Object value) {
        return this.gson.toJson(value);
    }
}

