/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services;

import io.qase.api.enums.Automation;
import io.qase.api.enums.Behavior;
import io.qase.api.enums.Filters;
import io.qase.api.enums.Priority;
import io.qase.api.enums.Severity;
import io.qase.api.enums.Status;
import io.qase.api.enums.Type;
import io.qase.api.inner.RouteFilter;
import io.qase.api.models.v1.testcases.TestCase;
import io.qase.api.models.v1.testcases.TestCases;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;

public interface TestCaseService {
    public TestCases getAll(String var1, int var2, int var3, RouteFilter var4);

    public TestCases getAll(String var1, RouteFilter var2);

    public TestCases getAll(String var1);

    public TestCase get(String var1, int var2);

    public boolean delete(String var1, int var2);

    default public Filter filter() {
        return new Filter();
    }

    public static class Filter
    implements RouteFilter {
        private final Map<Filters, String> filters = new EnumMap<Filters, String>(Filters.class);

        private Filter() {
        }

        @Override
        public Map<Filters, String> getFilters() {
            return Collections.unmodifiableMap(this.filters);
        }

        public Filter search(String search) {
            this.filters.put(Filters.search, search);
            return this;
        }

        public Filter milestoneId(int id) {
            this.filters.put(Filters.milestone_id, String.valueOf(id));
            return this;
        }

        public Filter suiteId(int id) {
            this.filters.put(Filters.suite_id, String.valueOf(id));
            return this;
        }

        public Filter severity(Severity ... severity) {
            this.filters.put(Filters.severity, Arrays.stream(severity).map(Enum::name).collect(Collectors.joining(",")));
            return this;
        }

        public Filter priority(Priority ... priorities) {
            this.filters.put(Filters.priority, Arrays.stream(priorities).map(Enum::name).collect(Collectors.joining(",")));
            return this;
        }

        public Filter type(Type ... types) {
            this.filters.put(Filters.type, Arrays.stream(types).map(Enum::name).collect(Collectors.joining(",")));
            return this;
        }

        public Filter behavior(Behavior ... behaviors) {
            this.filters.put(Filters.behavior, Arrays.stream(behaviors).map(Enum::name).collect(Collectors.joining(",")));
            return this;
        }

        public Filter automation(Automation ... automation) {
            this.filters.put(Filters.automation, Arrays.stream(automation).map(Automation::getName).collect(Collectors.joining(",")));
            return this;
        }

        public Filter status(Status ... statuses) {
            this.filters.put(Filters.status, Arrays.stream(statuses).map(Enum::name).collect(Collectors.joining(",")));
            return this;
        }
    }
}

